<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('nps_pesquisas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('usuario_id');
            $table->unsignedBigInteger('empresa_id');
            $table->tinyInteger('nota')->nullable(); // Nota de 0 a 10
            $table->text('feedback')->nullable(); // Feedback aberto, opcional
            $table->boolean('ignorado')->default(false); // Se o usuário ignorou a pesquisa
            $table->boolean('respondido')->default(false); // Se o usuário respondeu a pesquisa
            $table->date('mes_referencia'); // Mês de referência da pesquisa (YYYY-MM-01)
            $table->timestamps();
            
            // Chaves estrangeiras
            $table->foreign('usuario_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('cascade');
            
            // Índices
            $table->index(['usuario_id', 'mes_referencia']); // Para buscar se usuário já respondeu naquele mês
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('nps_pesquisas');
    }
};
