<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('devolucoes', function (Blueprint $table) {
            $table->foreignId('caixa_id')->nullable()->constrained('caixas')->after('cliente_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('devolucoes', function (Blueprint $table) {
            $table->dropForeign(['caixa_id']);
            $table->dropColumn('caixa_id');
        });
    }
}; 