<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('recebimento_planos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('financeiro_plano_id')->constrained('financeiro_planos');
            $table->date('data_pagamento');
            $table->decimal('valor_pago', 10, 2);
            $table->string('forma_pagamento', 50);
            $table->text('observacao')->nullable();
            $table->foreignId('user_id')->nullable()->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('recebimento_planos');
    }
}; 