<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConfiguracoesFinanceirasTable extends Migration
{
    public function up()
    {
        Schema::create('configuracoes_financeiras', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empresa_id');
            
            // Juros e multas
            $table->decimal('juros_diario', 5, 3)->default(0.033); // 0.033% ao dia (1% ao mês)
            $table->decimal('multa_atraso', 5, 2)->default(2.00);  // 2% fixo
            $table->integer('carencia_dias')->default(0);          // Dias de carência antes de aplicar juros
            
            // Prazos
            $table->integer('prazo_padrao_dias')->default(30);     // Prazo padrão para novas contas
            
            // Notificações
            $table->boolean('notificar_vencimento')->default(true);
            $table->integer('dias_notificacao_previa')->default(3);
            
            // Recibos
            $table->text('texto_padrao_recibo')->nullable();
            
            // Boletos
            $table->text('instrucoes_padrao_boleto')->nullable();
            
            $table->timestamps();
            
            // Chave estrangeira
            $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('cascade');
            
            // Garantir apenas uma configuração por empresa
            $table->unique('empresa_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('configuracoes_financeiras');
    }
} 