<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMovimentosEstoqueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('movimentos_estoque', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('produto_id');
            $table->decimal('quantidade_anterior', 10, 2)->default(0);
            $table->decimal('quantidade_nova', 10, 2)->default(0);
            $table->decimal('diferenca', 10, 2)->default(0);
            $table->string('tipo')->comment('ajuste, entrada, saida, transferencia, inventario');
            $table->string('operacao')->comment('entrada, saida');
            $table->text('observacao')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('inventario_id')->nullable();
            $table->timestamps();
            
            // Relacionamentos
            $table->foreign('produto_id')->references('id')->on('produtos');
            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('inventario_id')->references('id')->on('inventarios');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('movimentos_estoque');
    }
} 