<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Events\Failed;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;
use App\Events\NovaEmpresaRegistrada;
use App\Events\LimiteUsoAtingido;
use App\Listeners\EnviarEmailNovaEmpresa;
use App\Listeners\InsertUnidadesMedidaListener;
use App\Listeners\NotificarLimiteUso;
use App\Listeners\LogTentativaLogin;
use App\Models\Nfe;
use App\Models\Nfce;
use App\Models\FaturaNfe;
use App\Models\FaturaNfce;
use App\Models\TaxaPagamento;
use App\Observers\NfeTaxaObserver;
use App\Observers\NfceTaxaObserver;
use App\Observers\FaturaNfeTaxaObserver;
use App\Observers\FaturaNfceTaxaObserver;
use App\Observers\TaxaPagamentoHistoricoObserver;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        NovaEmpresaRegistrada::class => [
            EnviarEmailNovaEmpresa::class,
            InsertUnidadesMedidaListener::class,
        ],
        LimiteUsoAtingido::class => [
            NotificarLimiteUso::class,
        ],
        Failed::class => [
            LogTentativaLogin::class,
        ],
    ];

    /**
     * Register any events for your application.
     */
    public function boot(): void
    {
        // Registrar os observers para armazenar a taxa vigente nas vendas
        // Cada modelo tem seu próprio observer para evitar sobrecarga de métodos
        Nfe::observe(NfeTaxaObserver::class);
        Nfce::observe(NfceTaxaObserver::class);
        FaturaNfe::observe(FaturaNfeTaxaObserver::class);
        FaturaNfce::observe(FaturaNfceTaxaObserver::class);
        
        // Registrar o observer para histórico de alterações de taxas
        TaxaPagamento::observe(TaxaPagamentoHistoricoObserver::class);
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     */
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
