<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RecebimentoPlano extends Model
{
    use HasFactory;

    protected $fillable = [
        'financeiro_plano_id',
        'data_pagamento',
        'valor_pago',
        'valor_repasse',
        'forma_pagamento',
        'observacao',
        'user_id'
    ];

    protected $casts = [
        'data_pagamento' => 'date',
    ];

    public function financeiroPlano()
    {
        return $this->belongsTo(FinanceiroPlano::class, 'financeiro_plano_id');
    }

    public function usuario()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
} 