<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MovimentoEstoque extends Model
{
    use HasFactory;

    protected $table = 'movimentos_estoque';

    protected $fillable = [
        'produto_id',
        'quantidade_anterior',
        'quantidade_nova',
        'diferenca',
        'tipo',
        'operacao',
        'observacao',
        'user_id',
        'inventario_id'
    ];

    /**
     * Relacionamento com produto
     */
    public function produto()
    {
        return $this->belongsTo(Produto::class);
    }

    /**
     * Relacionamento com usuário
     */
    public function usuario()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Relacionamento com inventário
     */
    public function inventario()
    {
        return $this->belongsTo(Inventario::class);
    }
} 