<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItemDevolucao extends Model
{
    use HasFactory;
    
    protected $table = 'itens_devolucao';
    
    protected $fillable = [
        'devolucao_id',
        'item_id',
        'tipo_item', // 'item_nfe' ou 'item_nfce'
        'quantidade',
        'valor_unitario',
        'produto_id',
        'variacao_id'
    ];
    
    // Relacionamentos
    public function devolucao()
    {
        return $this->belongsTo(Devolucao::class, 'devolucao_id');
    }
    
    public function produto()
    {
        return $this->belongsTo(Produto::class, 'produto_id');
    }
    
    // Para obter o item original da NFe ou NFCe
    public function itemOriginal()
    {
        if ($this->tipo_item == 'item_nfe') {
            return ItemNfe::find($this->item_id);
        } else {
            return ItemNfce::find($this->item_id);
        }
    }
} 