<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItemComanda extends Model
{
    use HasFactory;

    protected $table = 'mesa_comanda_items';

    protected $fillable = [
        'empresa_id',
        'mesa_comanda_id',
        'produto_id',
        'quantidade',
        'valor_unitario',
        'subtotal',
    ];

    public function mesaComanda()
    {
        return $this->belongsTo(MesaComanda::class);
    }

    public function produto()
    {
        return $this->belongsTo(Produto::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }
} 