<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CategoriaConta extends Model
{
    use HasFactory;

    protected $table = 'categoria_contas';

    protected $fillable = [
        'nome',
        'descricao',
        'empresa_id',
        'cor',
        'icone',
        'tipo',
        'pai_id',
        'ativo'
    ];

    public function contasPagar()
    {
        return $this->hasMany(ContaPagar::class, 'categoria_id');
    }

    public function contasReceber()
    {
        return $this->hasMany(ContaReceber::class, 'categoria_id');
    }

    public function pai()
    {
        return $this->belongsTo(CategoriaConta::class, 'pai_id');
    }

    public function filhos()
    {
        return $this->hasMany(CategoriaConta::class, 'pai_id');
    }

    public static function tipos()
    {
        return [
            'pagar' => 'Contas a Pagar',
            'receber' => 'Contas a Receber',
            'ambos' => 'Ambos'
        ];
    }
} 