<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class PlanosExpiracaoNotificacao extends Mailable
{
    use Queueable, SerializesModels;

    public $planosAgrupados;

    /**
     * Create a new message instance.
     *
     * @param Collection $planosAgrupados
     * @return void
     */
    public function __construct(Collection $planosAgrupados)
    {
        $this->planosAgrupados = $planosAgrupados;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $total = $this->planosAgrupados->flatten()->count();
        
        return $this->subject("Alerta: {$total} Planos Próximos da Expiração - NGBPrime")
            ->markdown('emails.sistema.planos-expiracao')
            ->with([
                'planosAgrupados' => $this->planosAgrupados,
                'total' => $total,
                'dataAtual' => now()->format('d/m/Y H:i:s')
            ]);
    }
} 