<?php

namespace App\Listeners;

use App\Events\NovaEmpresaRegistrada;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use App\Mail\NovaEmpresaNotificacao;
use App\Services\NotificacaoService;

class EnviarEmailNovaEmpresa implements ShouldQueue
{
    use InteractsWithQueue;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  NovaEmpresaRegistrada  $event
     * @return void
     */
    public function handle(NovaEmpresaRegistrada $event)
    {
        $empresa = $event->empresa;
        
        // Obtém a lista de destinatários
        $destinatarios = NotificacaoService::getDestinatarios();
        
        // Log de início do processo
        Log::info('Iniciando envio de notificação de nova empresa', [
            'empresa_id' => $empresa->id,
            'empresa_nome' => $empresa->nome,
            'destinatarios' => $destinatarios
        ]);
        
        try {
            // Envio de e-mail
            foreach ($destinatarios as $dest) {
                Mail::to($dest)->send(new NovaEmpresaNotificacao($empresa));
                Log::info("Email enviado com sucesso para {$dest}");
            }
        } catch (\Exception $e) {
            Log::error('Erro ao enviar email de notificação de nova empresa', [
                'erro' => $e->getMessage(),
                'empresa_id' => $empresa->id
            ]);
        }
    }
} 