<?php

namespace App\Imports;

use App\Models\Ncm;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class NcmImport implements ToCollection
{
    /**
     * @param Collection $rows
     */
    public function collection(Collection $rows)
    {
        foreach ($rows as $key => $row) {
            // Ignorar linhas em branco ou cabeçalho
            if (!isset($row[0]) || empty($row[0]) || $row[0] == 'Código' || $key < 1) {
                continue;
            }

            $codigo = trim((string)$row[0]);
            $descricao = trim((string)$row[1]);

            // Ignorar linhas onde o código ou descrição estão vazios
            if (empty($codigo) || empty($descricao)) {
                continue;
            }

            // Para entradas que começam com números, limpar os caracteres especiais
            if (is_numeric(substr($codigo, 0, 1))) {
                $descricao = str_replace("--", "", $descricao);
                $descricao = str_replace("-", "", $descricao);
            }

            Ncm::create([
                'codigo' => $codigo,
                'descricao' => "$codigo - $descricao"
            ]);
        }
    }
} 