<?php

namespace App\Http\Controllers;

use App\Models\Caixa;
use App\Models\Nfce;
use App\Models\Nfe;
use App\Models\SangriaCaixa;
use App\Models\Empresa;
use App\Models\SuprimentoCaixa;
use App\Models\ItemContaEmpresa;
use Illuminate\Http\Request;
use PhpParser\Node\Expr\FuncCall;
use Svg\Tag\Rect;
use App\Utils\ContaEmpresaUtil;
use Dompdf\Dompdf;
use Illuminate\Support\Facades\Log;

class SuprimentoController extends Controller
{

    protected $util;
    public function __construct(ContaEmpresaUtil $util){
        $this->util = $util;
    }

    public function store(Request $request)
    {
        try {
            // Validação dos dados recebidos
            if(!$request->valor || __convert_value_bd($request->valor) == 0){
                session()->flash("flash_error", "Informe um valor maior que zero");
                return redirect()->back();
            }
            
            if(!$request->tipo_pagamento){
                session()->flash("flash_error", "Selecione o tipo de pagamento");
                return redirect()->back();
            }
            
            // Registra o suprimento no banco de dados
            $suprimento = SuprimentoCaixa::create([
                'caixa_id' => $request->caixa_id,
                'valor' => __convert_value_bd($request->valor),
                'observacao' => $request->observacao ?? '',
                'tipo_pagamento' => $request->tipo_pagamento,
            ]);

            // Processa as transações de conta empresa, se necessário
            if($request->conta_empresa_suprimento_id){
                $caixa = Caixa::findOrFail($request->caixa_id);
                $data = [
                    'conta_id' => $caixa->conta_empresa_id,
                    'descricao' => "Suprimento de caixa",
                    'tipo_pagamento' => $request->tipo_pagamento,
                    'valor' => __convert_value_bd($request->valor),
                    'caixa_id' => $caixa->id,
                    'tipo' => 'entrada'
                ];
                $itemContaEmpresa = ItemContaEmpresa::create($data);
                $this->util->atualizaSaldo($itemContaEmpresa);

                $data = [
                    'conta_id' => $request->conta_empresa_suprimento_id,
                    'descricao' => "Suprimento de caixa",
                    'tipo_pagamento' => $request->tipo_pagamento,   
                    'valor' => __convert_value_bd($request->valor),
                    'caixa_id' => $caixa->id,
                    'tipo' => 'saida'
                ];
                $itemContaEmpresa = ItemContaEmpresa::create($data);
                $this->util->atualizaSaldo($itemContaEmpresa);
            }
            
            // Armazena o ID na sessão para abrir a impressão após o redirecionamento
            session()->flash('suprimento_id', $suprimento->id);
            session()->flash('flash_success', 'Suprimento realizado com sucesso!');
            
            return redirect()->back();
            
        } catch (\Exception $e) {
            // Registra o erro no log
            Log::error("Erro ao processar suprimento: " . $e->getMessage());
            
            // Feedback para o usuário
            session()->flash("flash_error", "Erro ao processar suprimento: " . $e->getMessage());
            return redirect()->back();
        }
    }

    public function print($id){
        $suprimento = SuprimentoCaixa::findOrfail($id);
        $empresa = Empresa::findOrFail(request()->empresa_id);
        $p = view('front_box.suprimento_print', compact('suprimento', 'empresa'));
        $domPdf = new Dompdf(["enable_remote" => true]);
        $domPdf->loadHtml($p);

        $pdf = ob_get_clean();

        $domPdf->set_paper(array(0,0,214,220));
        $domPdf->render();
        $domPdf->stream("Comprovante de suprimento.pdf", array("Attachment" => false));
        exit();
    }
}
