<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Empresa;

class CorrigirLogosEmpresa extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'empresa:corrigir-logos';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Corrige logos de empresas que não existem no sistema';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $empresas = Empresa::whereNotNull('logo')->where('logo', '!=', '')->get();
        
        $this->info("Verificando logos de {$empresas->count()} empresas...");
        
        $corrigidas = 0;
        
        foreach ($empresas as $empresa) {
            $logoPath = public_path('/uploads/logos/') . $empresa->logo;
            
            if (!file_exists($logoPath)) {
                $this->warn("Logo não encontrado para empresa {$empresa->nome}: {$empresa->logo}");
                
                // Limpa o campo logo
                $empresa->update(['logo' => null]);
                $corrigidas++;
                
                $this->info("Logo removido da empresa {$empresa->nome}");
            }
        }
        
        $this->info("Processo concluído! {$corrigidas} logos foram corrigidas.");
        
        return 0;
    }
} 