<div class="row g-2">

    <!-- Contexto da empresa para o backend -->
    <input type="hidden" name="empresa_id" id="empresa_id" value="{{ request()->empresa_id }}">

    <!-- Select mestre de produto (oculto) para ser clonado nas linhas dinâmicas -->
    <div id="produto-select-master" class="d-none">
        <select class="form-select produto-select">
            <option value="">Selecione</option>
            @foreach(($produtos ?? []) as $pp)
                <option value="{{ $pp->id }}" data-unidade="{{ $pp->unidade }}">{{ $pp->nome }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-3">
        {!!Form::date('data_producao', 'Data da Produção')
            ->required(true)
            ->value(old('data_producao', isset($op) && $op->data_producao ? $op->data_producao : date('Y-m-d')))
        !!}
    </div>
    <div class="col-md-4">
        <?php
            $cliId = old('cliente_id', isset($op) ? $op->cliente_id : null);
        ?>
        <div class="mb-3">
            <label for="inp-cliente_id" class="form-label">Cliente/Destinatário</label>
            <select name="cliente_id" class="form-select" id="inp-cliente_id">
                <option value="">Selecione</option>
                @if(isset($clientesOptions) && is_array($clientesOptions) || is_object($clientesOptions))
                    @foreach($clientesOptions as $id => $nome)
                        <option value="{{ $id }}" {{ $cliId == $id ? 'selected' : '' }}>{{ $nome }}</option>
                    @endforeach
                @endif
            </select>
        </div>
    </div>
    <div class="col-md-3">
        {!!Form::date('data_prevista_entrega', 'Data prevista de entrega')
            ->value(old('data_prevista_entrega', isset($op) && $op->data_prevista_entrega ? $op->data_prevista_entrega : date('Y-m-d')))
        !!}
    </div>
    <div class="col-md-12">
        {!!Form::textarea('observacao', 'Observação')->attrs(['rows' => 2])!!}
    </div>

    @if(isset($data) && count($data))
    <div class="col-md-12 table-responsible mt-3">
        <label class="form-label">Itens pendentes de produção (opcional)</label>
        <table class="table table-sm">
            <thead class="table-dark">
                <tr>
                    <th>
                        <div class="form-check form-checkbox-danger mb-2">
                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                        </div>
                    </th>
                    <th>Produto</th>
                    <th>Quantidade</th>
                </tr>
            </thead>
            <tbody>
                @foreach($data as $i)
                <tr>
                    <td>
                        <div class="form-check form-checkbox-danger mb-2">
                            <input class="form-check-input check-delete" type="checkbox" name="item_select[]" value="{{ $i->id }}">
                        </div>
                    </td>
                    <td>{{ optional($i->produto)->nome }}</td>
                    <td>{{ number_format($i->quantidade, 3, ',', '.') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    <div class="col-md-12 mt-3">
        <div class="d-flex justify-content-between align-items-center">
            <label class="form-label">Itens da Ordem (entrada manual)</label>
            <button type="button" class="btn btn-primary btn-sm" id="add-row"><i class="ri-add-circle-line"></i> Adicionar item</button>
        </div>
        <div class="table-responsive">
            <table class="table table-bordered align-middle" id="itens-table">
                <thead class="table-light">
                    <tr>
                        <th style="width:55%">Produto</th>
                        <th style="width:15%">UN</th>
                        <th style="width:20%">Quantidade</th>
                        <th style="width:10%">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @if(isset($op) && isset($op->itens) && count($op->itens))
                        @foreach($op->itens as $it)
                        <tr>
                            <td>
                                <select name="produtos[][produto_id]" class="form-select produto-select">
                                    <option value="">Selecione</option>
                                    @foreach(($produtos ?? []) as $pp)
                                        <option value="{{ $pp->id }}" data-unidade="{{ $pp->unidade }}" {{ (int)$it->produto_id === (int)$pp->id ? 'selected' : '' }}>{{ $pp->nome }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control un" value="{{ optional($it->produto)->unidade }}" placeholder="UN" readonly>
                            </td>
                            <td>
                                <input type="text" inputmode="decimal" name="produtos[][quantidade]" class="form-control quantidade-input" value="{{ number_format((float)$it->quantidade, 2, ',', '.') }}" placeholder="0,00">
                            </td>
                            <td class="text-center">
                                <button type="button" class="btn btn-danger btn-sm remove-row"><i class="ri-delete-bin-line"></i></button>
                            </td>
                        </tr>
                        @endforeach
                    @endif
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="2" class="text-end">Total</th>
                        <th class="text-end"><span id="total-quantidade-display">0,00</span></th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <hr class="mt-2">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>

@section('js')
<!-- Activos do Select2 para permitir pesquisa por digitação no select de produto -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
/* Forçar Select2 a exibir o nome completo (quebra de linha e altura auto) */
.select2-container--default .select2-selection--single .select2-selection__rendered {
  white-space: normal !important;
  word-break: break-word;
  text-overflow: clip !important;
  overflow: visible !important;
  line-height: 1.2em !important;
  display: block !important;
  padding-right: 28px !important; /* evitar sobreposição da seta */
}
.select2-container .select2-selection--single { height: auto !important; min-height: 38px; }
.select2-container--default .select2-selection--single { padding-top: 6px !important; padding-bottom: 6px !important; }
.select2-container--default .select2-selection--single .select2-selection__arrow { height: 100%; }
.select2-container { width: 100% !important; }
/* Garantir que o container acomode múltiplas linhas */
.select2-container .select2-selection--single .select2-selection__rendered { white-space: normal !important; }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script type="text/javascript">
    (function(){
        const produtos = @json($produtosJs ?? []);

        // Preenche os selects de produto a partir do select mestre
        function populateProdutoSelect(ctx){
            const master = document.querySelector('#produto-select-master select');
            (ctx || document).querySelectorAll('.produto-select').forEach(sel => {
                // Só popular selects novos/vazios (evita resetar seleções já feitas)
                if (!master) return;
                const needsPopulate = sel.options.length <= 1; // apenas placeholder
                if (needsPopulate) {
                    const currentValue = sel.value;
                    sel.innerHTML = master.innerHTML;
                    if (currentValue) sel.value = currentValue;
                }
            });
        }

        // Inicializa Select2 com pesquisa AJAX para os selects de produto
        function initSelect2(ctx){
            if (!window.jQuery || !jQuery.fn.select2) return;
            jQuery(ctx || document).find('.produto-select').each(function(){
                const $el = jQuery(this);
                if ($el.data('select2')) return; // já inicializado
                $el.select2({
                    placeholder: 'Digite para pesquisar o produto',
                    allowClear: true,
                    width: '100%',
                    minimumInputLength: 2,
                    language: {
                        inputTooShort: () => 'Por favor digite 2 ou mais caracteres',
                        noResults: () => 'Sem resultados',
                        searching: () => 'A pesquisar...'
                    },
                    ajax: {
                        delay: 250,
                        cache: true,
                        url: '{{ route('api.produtos.search') }}',
                        data: function (params) {
                            return {
                                term: params.term || '',
                                empresa_id: '{{ request()->empresa_id }}'
                            };
                        },
                        processResults: function (data) {
                            return { results: data.results };
                        }
                    },
                    templateSelection: function (data) { return data.text || data.id; },
                    templateResult: function (data) { return data.text || ''; }
                });

                // ao selecionar via Select2, preencher UN
                $el.on('select2:select', function(e){
                    const item = e.params.data || {};
                    const tr = this.closest('tr');
                    if (tr) {
                        const un = item.unidade || (produtos.find(p=> String(p.id)===String(item.id))?.unidade || '');
                        tr.querySelector('.un').value = un;
                    }
                });
            });
        }

        // Constrói uma nova linha de item
        function novaLinha(){
            return `<tr>
                <td>
                    <select name="produtos[][produto_id]" class="form-select produto-select"></select>
                </td>
                <td>
                    <input type="text" class="form-control un" value="" placeholder="UN" readonly>
                </td>
                <td>
                    <input type="text" inputmode="decimal" name="produtos[][quantidade]" class="form-control quantidade-input" placeholder="0,00">
                </td>
                <td class="text-center">
                    <button type="button" class="btn btn-danger btn-sm remove-row"><i class="ri-delete-bin-line"></i></button>
                </td>
            </tr>`;
        }

        function bindEvents(ctx){
            // mudança em selects normais (sem Select2) -> preencher UN por array local
            (ctx || document).querySelectorAll('.produto-select').forEach(sel => {
                sel.addEventListener('change', function(){
                    const id = this.value;
                    const p = produtos.find(pp => String(pp.id) === String(id));
                    const un = p?.unidade || '';
                    const tr = this.closest('tr');
                    if(tr){ tr.querySelector('.un').value = un; }
                });
            });
            (ctx || document).querySelectorAll('.remove-row').forEach(btn => {
                btn.addEventListener('click', function(){
                    this.closest('tr')?.remove();
                    recalcTotal(ctx);
                });
            });
        }

        // Adicionar nova linha de item
        document.getElementById('add-row')?.addEventListener('click', function(){
            const tbody = document.querySelector('#itens-table tbody');
            tbody.insertAdjacentHTML('beforeend', novaLinha());
            populateProdutoSelect(tbody);
            bindEvents(tbody);
            bindQuantidadeEvents(tbody);
            initSelect2(tbody);
            recalcTotal(tbody);
        });

        document.getElementById('select-all-checkbox')?.addEventListener('change', function(){
            document.querySelectorAll('.check-delete').forEach(c => c.checked = !!this.checked);
        });

        // Iniciar com uma linha para sugerir a utilização (apenas se vazio)
        const tbody = document.querySelector('#itens-table tbody');
        if (tbody && tbody.children.length === 0){
            tbody.insertAdjacentHTML('beforeend', novaLinha());
        }
        // Sempre inicializar selects/eventos, inclusive para linhas pré-renderizadas (edição)
        if (tbody){
            populateProdutoSelect(tbody);
            bindEvents(tbody);
            bindQuantidadeEvents(tbody);
            initSelect2(tbody);
            recalcTotal(tbody);
        }
        // Inicializa Select2 do cliente usando as opções já renderizadas (sem AJAX)
        (function initClienteSelect(){
            if (typeof jQuery === 'undefined' || !jQuery.fn.select2) return;
            const $cli = jQuery('#inp-cliente_id');
            if (!$cli.length || $cli.data('select2') || $cli.attr('data-select2-initialized') === 'true') return;
            
            // Marcar como inicializado para evitar dupla inicialização
            $cli.attr('data-select2-initialized', 'true');
            
            $cli.select2({
                width: '100%',
                placeholder: 'Selecione',
                allowClear: true,
                language: { noResults: () => 'Sem resultados' },
                templateSelection: function (data) { return data.text || data.id; },
                templateResult: function (data) { return data.text || ''; }
            });
            // Restaura valor anterior (old) ou valor atual da OP em edição
            const cliId = @json(old('cliente_id', isset($op) ? $op->cliente_id : null));
            if (cliId) { $cli.val(String(cliId)).trigger('change'); }
        
            // Garante tooltip com o texto completo sempre
            const setTitleFullText = () => {
                const $rendered = $cli.next('.select2').find('.select2-selection__rendered');
                const text = $cli.find('option:selected').text();
                if ($rendered.length) {
                    $rendered.attr('title', text || '');
                }
            };
            setTitleFullText();
            $cli.on('change select2:select', setTitleFullText);
        })();

        // Preencher datas automaticamente (AAAA-MM-DD) e manter entrega >= produção
        (function handleDates(){
            const toISODate = (d) => {
                const pad = (n) => String(n).padStart(2,'0');
                return `${d.getFullYear()}-${pad(d.getMonth()+1)}-${pad(d.getDate())}`;
            };
            const today = toISODate(new Date());
            const dp = document.querySelector('input[name="data_producao"]');
            const de = document.querySelector('input[name="data_prevista_entrega"]');

            if (dp) {
                if (!dp.value) dp.value = today;
            }
            if (de) {
                if (!de.value) de.value = today;
            }

            // Garantir que a entrega não fique antes da produção
            function syncMinDelivery(){
                if (!dp || !de) return;
                de.min = dp.value || '';
                if (de.value && dp.value && de.value < dp.value){
                    de.value = dp.value;
                }
            }

            // Se o utilizador alterar a produção, actualizar entrega se ainda não tiver sido personalizada
            let userSetDelivery = false;
            if (de){
                de.addEventListener('input', function(){
                    userSetDelivery = true; // utilizador a alterar a data de entrega
                });
            }

            if (dp){
                // Keep the last production date to detect if delivery equals old production
                let lastProd = dp.value;
                dp.addEventListener('change', function(){
                    const newProd = dp.value;
                    if (de){
                        // Auto-adjust de if it was empty or equal to the previous production date, or if user hasn't changed it
                        if (!de.value || !userSetDelivery || de.value === lastProd){
                            de.value = newProd;
                        }
                    }
                    lastProd = newProd;
                    syncMinDelivery();
                });
            }

            syncMinDelivery();
        })();

        // Formatação de quantidade (pt-PT) com 2 casas; no envio converter para ponto decimal
        function normalizeToNumber(val){
            if (val === null || val === undefined) return NaN;
            val = String(val).trim();
            // Remover separador de milhares '.' e trocar vírgula decimal por ponto
            val = val.replace(/\./g, '').replace(',', '.');
            const n = parseFloat(val);
            return isNaN(n) ? NaN : n;
        }
        function formatPtBR2(n){
            try {
                return (n).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            } catch(e){
                return Number(n).toFixed(2).replace('.', ',');
            }
        }
        // Recalcula o total de quantidades no rodapé
        function recalcTotal(ctx){
            const root = ctx || document;
            let total = 0;
            root.querySelectorAll('#itens-table tbody .quantidade-input').forEach(inp => {
                const n = normalizeToNumber(inp.value);
                if (!isNaN(n)) total += n;
            });
            const el = document.getElementById('total-quantidade-display');
            if (el) el.textContent = formatPtBR2(total);
        }
        // Ligar eventos de quantidade SEM máscara ao digitar
        function bindQuantidadeEvents(ctx){
            (ctx || document).querySelectorAll('.quantidade-input').forEach(inp => {
                // Não formatar durante a digitação; apenas impedir caracteres inválidos
                inp.addEventListener('input', function(){
                    this.value = this.value.replace(/[^0-9.,]/g, '');
                    recalcTotal(ctx);
                });
                // Sem formatação em blur/change para manter exatamente o que o usuário digitou
            });
        }
        bindQuantidadeEvents();
        // calcular total inicial
        recalcTotal();

        function prepareBeforeSubmit(form){
            // Validar pelo menos um item com produto e quantidade > 0
            const rows = Array.from(form.querySelectorAll('#itens-table tbody tr'));
            const hasValidItem = rows.some(tr => {
                const sel = tr.querySelector('.produto-select');
                const qtyInp = tr.querySelector('.quantidade-input');
                const qn = normalizeToNumber(qtyInp?.value || '');
                return sel && sel.value && !isNaN(qn) && qn > 0;
            });
            if (!hasValidItem) {
                alert('Informe pelo menos um item com produto e quantidade maior que zero.');
                return false;
            }

            // Reindexar apenas linhas válidas e remover nomes das inválidas
            let idx = 0;
            rows.forEach(tr => {
                const sel = tr.querySelector('.produto-select');
                const qtyInp = tr.querySelector('.quantidade-input');
                const qn = normalizeToNumber(qtyInp?.value || '');
                const valid = sel && sel.value && !isNaN(qn) && qn > 0;
                if (valid) {
                    // Converter quantidade para ponto decimal com 2 casas
                    qtyInp.value = normalizeToNumber(qtyInp.value).toFixed(2);
                    // Garantir nomes contíguos
                    sel.setAttribute('name', `produtos[${idx}][produto_id]`);
                    qtyInp.setAttribute('name', `produtos[${idx}][quantidade]`);
                    idx++;
                } else {
                    // Evitar envio de campos inválidos (remover name)
                    if (sel) sel.removeAttribute('name');
                    if (qtyInp) qtyInp.removeAttribute('name');
                }
            });
            return true;
        }

        // Handler no botão Salvar para garantir preparação antes do submit
        document.getElementById('btn-store')?.addEventListener('click', function(ev){
            ev.preventDefault();
            const form = this.closest('form') || document.querySelector('form');
            if (!form) return;
            if (prepareBeforeSubmit(form)) form.submit();
        });

        // Fallback: se o submit vier por enter no input, ainda prepara
        document.querySelector('form')?.addEventListener('submit', function(e){
            if (!prepareBeforeSubmit(this)){
                e.preventDefault();
            }
        });
    })();
</script>
@endsection
