<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Relatório de Venda</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }

        body {
            background: #fff;
            padding: 20px;
            color: #444;
            line-height: 1.4;
            font-size: 12px;
        }

        /* Cabeçalho */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
            padding-bottom: 0;
            border-bottom: 1px solid #edf2f7;
        }

        .header img {
            max-height: 50px;
            object-fit: contain;
        }

        .company-info {
            text-align: right;
        }

        .company-info h2 {
            color: #1a202c;
            font-size: 18px;
            font-weight: 500;
            margin-bottom: 4px;
            text-align: left !important;
        }

        .company-info p {
            color: #718096;
            font-size: 11px;
            line-height: 1.3;
        }

        /* Seções */
        .section {
            background: #fff;
            border: 1px solid #edf2f7;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
        }

        .section h3 {
            color: #2d3748;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 10px;
            padding-bottom: 8px;
            border-bottom: 1px solid #edf2f7;
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            font-size: 11px;
        }

        .info-item {
            margin-bottom: 4px;
        }

        .info-label {
            color: #718096;
            margin-bottom: 2px;
        }

        .info-value {
            color: #2d3748;
            font-weight: 500;
        }

        /* Tabelas */
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
        }

        th {
            background: #f7fafc;
            padding: 8px;
            text-align: left;
            font-weight: 500;
            color: #4a5568;
            border-bottom: 1px solid #edf2f7;
        }

        td {
            padding: 6px 8px;
            color: #2d3748;
            border-bottom: 1px solid #edf2f7;
        }

        tr:last-child td {
            border-bottom: none;
        }

        /* Totais */
        .totals {
            background: #f7fafc;
            border-radius: 8px;
            padding: 12px 15px;
            margin-top: 15px;
            font-size: 11px;
        }

        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 4px 0;
            color: #4a5568;
        }

        .total-row.final {
            margin-top: 8px;
            padding-top: 8px;
            border-top: 1px solid #e2e8f0;
            font-size: 14px;
            font-weight: 600;
            color: #2d3748;
        }

        /* Rodapé */
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #edf2f7;
            text-align: center;
            color: #a0aec0;
            font-size: 10px;
        }

        .footer p {
            margin: 2px 0;
        }

        /* Utilitários */
        .text-right { text-align: right; }
        .text-muted { color: #718096; }
        .font-medium { font-weight: 500; }
        
        @media print {
            body { padding: 10px; }
            .section { break-inside: avoid; }
            .page-break { page-break-after: always; }
        }
        .company-info, .company-info h2, .company-info p {
            text-align: left !important;
        }
        .company-info {
            padding-top: 0;
            padding-bottom: 15px;
            padding-left: 15px;
        }
        .numero-nta-info {
            /* padding-top: 0; */
            padding-bottom: 15px;
            padding-left: 15px;
        }
        .numero-nta-info, .numero-nta-info h2, .numero-nta-info p {
            text-align: left !important;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho -->
    <div class="header">
        {{-- Removido bloco de logo do topo da impressão --}}
        <div class="company-info">
            <h2>{{ $config->nome }}</h2>
            <p>{{ $config->rua }}, {{ $config->numero }} - {{ $config->bairro }}</p>
            <p>{{ $config->cidade->nome }}/{{ $config->cidade->uf }} - {{ $config->cpf_cnpj }}</p>
        </div>
    </div>

    <!-- Informações do Fornecedor -->
    <div class="section">
        <h3>Informações do Fornecedor</h3>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">Nome/Razão Social</div>
                <div class="info-value">
                    {{ $item->fornecedor ? ($item->fornecedor->razao_social ?? $item->fornecedor->nome ?? 'Fornecedor não informado') : 'Fornecedor não informado' }}
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    {{ $item->fornecedor && $item->fornecedor->cpf_cnpj ? (strlen($item->fornecedor->cpf_cnpj) > 14 ? 'CNPJ' : 'CPF') : 'CPF/CNPJ' }}
                </div>
                <div class="info-value">
                    {{ $item->fornecedor && $item->fornecedor->cpf_cnpj ? $item->fornecedor->cpf_cnpj : 'Não informado' }}
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">Endereço</div>
                <div class="info-value">
                    {{ $item->fornecedor && $item->fornecedor->rua ? $item->fornecedor->rua : 'Não informado' }},
                    {{ $item->fornecedor && $item->fornecedor->numero ? $item->fornecedor->numero : 'Não informado' }} -
                    {{ $item->fornecedor && $item->fornecedor->bairro ? $item->fornecedor->bairro : 'Não informado' }}
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">Cidade/UF</div>
                <div class="info-value">
                    {{ $item->fornecedor && $item->fornecedor->cidade && $item->fornecedor->cidade->nome ? $item->fornecedor->cidade->nome : 'Não informado' }}/
                    {{ $item->fornecedor && $item->fornecedor->cidade && $item->fornecedor->cidade->uf ? $item->fornecedor->cidade->uf : 'Não informado' }}
                </div>
            </div>
            <!-- <div class="info-item">
                <div class="info-label">Nº Nota Fiscal</div>
                <div class="info-value">{{ $item->numero }}</div>
            </div> -->
        </div>
    </div>

    <!-- Produtos -->
    <div class="section">
        <div class="info-item">
                <div class="info-label">Nº Nota Fiscal</div>
                <div class="info-value">{{ $item->numero }}</div>
                
        </div>
        <h3>Produtos</h3>
    <table>
        <thead>
            <tr>
                    <th style="width: 45%">Produto</th>
                    <th style="width: 15%">Qtd</th>
                    <th style="width: 20%">Valor Unit.</th>
                    <th style="width: 20%" class="text-right">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($item->itens as $i)
            <tr>
                    <td>{{ $i->produto->nome }}</td>
                    <td>{{ number_format($i->quantidade, 2, ',', '.') }}</td>
                    <td>{{ number_format($i->valor_unitario, 2, ',', '.') }}</td>
                    <td class="text-right">{{ number_format($i->sub_total, 2, ',', '.') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    </div>

    <!-- Pagamento -->
    <div class="section">
        <h3>Pagamento</h3>
    <table>
        <thead>
            <tr>
                    <th style="width: 40%">Forma</th>
                    <th style="width: 30%">Vencimento</th>
                    <th style="width: 30%" class="text-right">Valor</th>
            </tr>
        </thead>
        <tbody>
                @foreach($item->fatura as $f)
                <tr>
                    <td>{{ \App\Models\Nfe::getTipo($f->tipo_pagamento) }}</td>
                    <td>{{ \Carbon\Carbon::parse($f->data_vencimento)->format('d/m/Y') }}</td>
                    <td class="text-right">{{ number_format($f->valor, 2, ',', '.') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    </div>

    <!-- Totais -->
    <div class="totals">
        @if($item->desconto > 0)
        <div class="total-row">
            <span>Desconto</span>
            <span>-{{ number_format($item->desconto, 2, ',', '.') }}</span>
        </div>
    @endif
        @if($item->acrescimo > 0)
        <div class="total-row">
            <span>Acréscimo</span>
            <span>+{{ number_format($item->acrescimo, 2, ',', '.') }}</span>
        </div>
                    @endif
        <div class="total-row final">
            <span>Total</span>
            <span>{{ number_format($item->total, 2, ',', '.') }}</span>
        </div>
    </div>

    <!-- Rodapé -->
    <div class="footer">
        <p>Documento gerado em {{ date('d/m/Y H:i:s') }} - {{ $config->nome }}</p>
    </div>
    </body>
    </html>
