@extends('layouts.app', ['title' => 'Acessos Clientes'])
@section('css')
<style type="text/css">
    .card-header {
        border-bottom: 1px solid #999;
        margin-left: 5px;
        margin-right: 5px;
    }
</style>
@endsection

@section('content')
<div class="mt-3">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10 col-lg-8">
            <form method="get" action="{{ route('acessos-clientes.relatorio') }}">
                <div class="card">
                    <div class="card-header">
                        <h5>Análise de Acessos e Menus Mais Utilizados</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="ri-information-line"></i> Esta ferramenta permite mapear os menus e submenus mais acessados, além de fornecer métricas sobre o uso do sistema.
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-6 col-12">
                                {!!Form::date('start_date', 'Data inicial')
                                ->value(date('Y-m-d', strtotime('-30 days')))
                                !!}
                            </div>
                            <div class="col-md-6 col-12">
                                {!!Form::date('end_date', 'Data final')
                                ->value(date('Y-m-d'))
                                !!}
                            </div>
                            
                            <div class="col-md-12">
                                {!!Form::select('empresa_id', 'Empresa', ['' => 'Todas as Empresas'] + $empresas->pluck('nome', 'id')->toArray())
                                ->attrs(['class' => 'form-select', 'id' => 'empresa_id'])
                                !!}
                            </div>
                            
                            <div class="col-md-12">
                                {!!Form::select('usuario_id', 'Usuário', ['' => 'Todos os Usuários'])
                                ->attrs(['class' => 'form-select', 'id' => 'usuario_id', 'disabled' => 'disabled'])
                                !!}
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="ignorar_superadmin" id="ignorar_superadmin" value="1" checked>
                                    <label class="form-check-label" for="ignorar_superadmin">
                                        Ignorar SuperAdmin nos relatórios
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="ri-bar-chart-box-line"></i> Gerar Relatório de Acessos
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        // Atualiza a lista de usuários quando a empresa for selecionada
        $('#empresa_id').change(function() {
            const empresaId = $(this).val();
            const usuarioSelect = $('#usuario_id');
            
            if (empresaId) {
                $.ajax({
                    url: "{{ route('acessos-clientes.usuarios-por-empresa') }}",
                    type: "GET",
                    data: { empresa_id: empresaId },
                    success: function(data) {
                        usuarioSelect.empty();
                        usuarioSelect.append('<option value="">Todos os Usuários</option>');
                        
                        $.each(data, function(key, value) {
                            usuarioSelect.append('<option value="' + value.id + '">' + value.name + '</option>');
                        });
                        
                        usuarioSelect.prop('disabled', false);
                    }
                });
            } else {
                usuarioSelect.empty();
                usuarioSelect.append('<option value="">Todos os Usuários</option>');
                usuarioSelect.prop('disabled', true);
            }
        });
    });
</script>
@endsection 