var EDIT = 0
$(function() {
    changeDericadoPetroleo()
    changeCardapio()
    changeDelivery()
    changeVariavel()
    changeEcommerce()
    changeCombo()
    changeMeradoLivre()
    changeNuvemShop()
    changeWoocommerce()
    if($('#edit').val() == 1){
        EDIT = 1
    }
    if($('.table-variacao tbody tr').length == 0){
        $('#inp-variacao_modelo_id').val('').change()
        $('#inp-sub_variacao_modelo_id').val('').change()
    }

    // Fix para checkboxes - garantir que sejam clicáveis
    // Removido stopPropagation global, só para checkboxes e labels
    $('.form-check-input').on('click', function(e) {
        // Apenas para o próprio checkbox
        // Não propaga para outros elementos, mas não bloqueia links
    });

    // Garantir que os checkboxes não sejam bloqueados por outros elementos
    $('.form-check-input').on('mousedown', function(e) {
        // Apenas para o próprio checkbox
    });

    // Fix adicional para checkboxes - forçar funcionalidade apenas no label do checkbox
    $('.form-check-input').each(function() {
        var $checkbox = $(this);
        var $label = $checkbox.closest('.form-check').find('strong');
        $label.off('click').on('click', function(e) {
            e.preventDefault();
            $checkbox.prop('checked', !$checkbox.prop('checked')).trigger('change');
        });
    });

    setTimeout(() => {
        if($('#inp-padrao_id').val()){
            $('#inp-padrao_id').change()
        }

        $('.select2-group').css('width', '80%')
    }, 1100)
})

$('#btn-store').click(() => {

})

$('.btn-store-marca').click(() => {
    let item = {
        nome: $('#inp-nome_marca').val(),
        empresa_id: $('#empresa_id').val()
    }

    $.post(path_url + "api/produtos/marca-store", item)
    .done((result) => {
        var newOption = new Option(result.nome, result.id, 1, false);
        $('#marca_id').append(newOption);
        $('#marca_id').val(result.id).change();
        $('#inp-nome_marca').val('')
        $('#modal_marca').modal('hide')
        swal("Sucesso", "Marca cadastrada!", "success")
    })
    .fail((err) => {
        console.log(err)
        swal("Erro", "Erro ao salvar marca", "error")
    })
})

$('.btn-store-categoria').click(() => {
    let item = {
        nome: $('#inp-nome_categoria').val(),
        empresa_id: $('#empresa_id').val()
    }

    $.post(path_url + "api/produtos/categoria-store", item)
    .done((result) => {
        var newOption = new Option(result.nome, result.id, 1, false);
        $('#categoria_id').append(newOption);
        $('#categoria_id').val(result.id).change();
        $('#inp-nome_categoria').val('')
        $('#modal_categoria_produto').modal('hide')
        swal("Sucesso", "Categoria cadastrada!", "success")
    })
    .fail((err) => {
        console.log(err)
        swal("Erro", "Erro ao salvar categoria", "error")
    })
})

function gerarCode(inp) {
    $.get(path_url + "produtos-gerar-codigo-ean")
    .done((res) => {
        if(inp == 1){
            $('#codigo_barras').val(res)
        }else{
            $('#codigo_barras'+inp).val(res)
        }
    })
    .fail((err) => {
        swal("Erro", "Erro ao buscar código", "error")
    })
}

$('.btn-action').click(() => {
    addClassRequired()
})

function addClassRequired() {
    let isInvalid = false
    let camposFaltando = []
    let camposFiscaisFaltando = []
    
    // Remove classes de erro anteriores
    $("body #form-produto").find('input, select').removeClass('is-invalid')
    
    // Validação da aba Identificação
    $("body #form-produto").find('input[required], select[required]').each(function () {
        if ($(this).val() == "" || $(this).val() == null) {
            $(this).addClass('is-invalid')
            isInvalid = true
            
            // Pega o label do campo
            let label = $(this).prev('label').text() || $(this).closest('.col-md-2, .col-md-3, .col-md-6').find('label').first().text() || $(this).attr('name')
            if (label) {
                camposFaltando.push(label.trim())
            }
        }
    })
    
    // Validação específica para campos fiscais (se necessário)
    if ($('#inp-padrao_id').val() || $('.tab-fiscal').hasClass('active')) {
        $('.tab-fiscal').trigger('click')
        
        // Verifica se há campos fiscais obrigatórios
        $("body #form-produto").find('input[required], select[required]').each(function () {
            if ($(this).val() == "" || $(this).val() == null) {
                $(this).addClass('is-invalid')
                isInvalid = true
                
                let label = $(this).prev('label').text() || $(this).closest('.col-md-2, .col-md-3, .col-md-6').find('label').first().text() || $(this).attr('name')
                if (label && !camposFaltando.includes(label.trim())) {
                    camposFiscaisFaltando.push(label.trim())
                }
            }
        })
    }
    
    // Validação específica para campos básicos essenciais
    let camposEssenciais = ['nome', 'valor_compra', 'percentual_lucro', 'valor_unitario', 'unidade']
    let camposEssenciaisFaltando = []
    
    camposEssenciais.forEach(function(campo) {
        let elemento = $("body #form-produto").find('[name="' + campo + '"]')
        if (elemento.length && (elemento.val() == "" || elemento.val() == null)) {
            camposEssenciaisFaltando.push(campo)
        }
    })

    setTimeout(() => {
        if(isInvalid){
            audioError()
            
            let mensagem = "Campos obrigatórios não preenchidos:\n\n"
            
            if (camposEssenciaisFaltando.length > 0) {
                mensagem += "📋 Campos básicos:\n"
                camposEssenciaisFaltando.forEach(function(campo) {
                    mensagem += "• " + campo.charAt(0).toUpperCase() + campo.slice(1).replace('_', ' ') + "\n"
                })
                mensagem += "\n"
            }
            
            if (camposFaltando.length > 0) {
                mensagem += "📝 Outros campos:\n"
                camposFaltando.forEach(function(campo) {
                    mensagem += "• " + campo + "\n"
                })
            }
            
            if (camposFiscaisFaltando.length > 0) {
                mensagem += "\n💰 Campos fiscais:\n"
                camposFiscaisFaltando.forEach(function(campo) {
                    mensagem += "• " + campo + "\n"
                })
            }
            
            // Usa SweetAlert para uma mensagem mais clara
            swal({
                title: "Campos Obrigatórios",
                text: mensagem,
                icon: "warning",
                buttons: {
                    confirm: {
                        text: "Entendi",
                        className: "btn btn-warning"
                    }
                }
            })
        } else {
            $body.addClass("loading");
        }
    }, 50)
}

$("#inp-sub_categoria_id").select2({
    minimumInputLength: 2,
    language: "pt-BR",
    placeholder: "Digite para buscar a subcategoria",
    width: "100%",
    ajax: {
        cache: true,
        url: path_url + "api/subcategorias",
        dataType: "json",
        data: function (params) {
            console.clear();
            var query = {
                pesquisa: params.term,
                categoria_id: $('#categoria_id').val()
            };
            return query;
        },
        processResults: function (response) {
            var results = [];

            $.each(response, function (i, v) {

                var o = {};
                o.id = v.id;
                o.text = v.nome
                results.push(o);
            });
            return {
                results: results,
            };
        },
    },
});

$(document).on("change", "#inp-padrao_id", function() {
    let padrao = $(this).val()
    if (padrao) {
        $.get(path_url + "api/produtos/padrao", {
            padrao: padrao
        })
        .done((result) => {
            if(EDIT == 0){
                // Preenche NCM se disponível
                if(result._ncm){
                    var newOption = new Option(result._ncm.descricao, result._ncm.codigo, 1, false);
                    $('#inp-ncm').append(newOption);
                    $('#inp-ncm').val(result.ncm).trigger('change');
                }

                // Preenche campos básicos
                $('#inp-cest').val(result.cest)
                $('#inp-perc_icms').val(result.perc_icms)
                $('#inp-perc_pis').val(result.perc_pis)
                $('#inp-perc_cofins').val(result.perc_cofins)
                $('#inp-perc_ipi').val(result.perc_ipi)
                $('#inp-cst_csosn').val(result.cst_csosn).change()
                $('#inp-cst_pis').val(result.cst_pis).change()
                $('#inp-cst_cofins').val(result.cst_cofins).change()
                $('#inp-cst_ipi').val(result.cst_ipi).change()
                $('#inp-cEnq').val(result.cEnq).change()
                $('#inp-cfop_estadual').val(result.cfop_estadual)
                $('#inp-cfop_outro_estado').val(result.cfop_outro_estado)
                $('#inp-codigo_beneficio_fiscal').val(result.codigo_beneficio_fiscal)
                $('#inp-cfop_entrada_estadual').val(result.cfop_entrada_estadual)
                $('#inp-cfop_entrada_outro_estado').val(result.cfop_entrada_outro_estado)
                $('#inp-modBCST').val(result.modBCST).change()
                $('#inp-pICMSST').val(result.pICMSST)
                $('#inp-pMVAST').val(result.pMVAST)
                $('#inp-redBCST').val(result.redBCST)
                
                // Mostra os campos de tributação se necessário
                if (result.perc_icms || result.cst_csosn) {
                    $('#campos-tributacao').show();
                    $('#btn-toggle-tributacao').html('<i class="fa fa-minus-circle me-1"></i> Ocultar campos adicionais de tributação');
                }
                
                // Notifica o usuário que os campos foram preenchidos
                toastr.success('Padrão de tributação aplicado com sucesso!', 'Sucesso');
            } else {
                EDIT = 0
            }
        })
        .fail((err) => {
            console.log(err)
            toastr.error('Erro ao carregar padrão de tributação', 'Erro');
        })
    } else {
        // Limpa os campos quando nenhum padrão é selecionado
        $('#inp-cest').val('')
        $('#inp-perc_icms').val('')
        $('#inp-perc_pis').val('')
        $('#inp-perc_cofins').val('')
        $('#inp-perc_ipi').val('')
        $('#inp-cst_csosn').val('').change()
        $('#inp-cst_pis').val('').change()
        $('#inp-cst_cofins').val('').change()
        $('#inp-cst_ipi').val('').change()
        $('#inp-cEnq').val('').change()
        $('#inp-cfop_estadual').val('')
        $('#inp-cfop_outro_estado').val('')
        $('#inp-codigo_beneficio_fiscal').val('')
        $('#inp-cfop_entrada_estadual').val('')
        $('#inp-cfop_entrada_outro_estado').val('')
        $('#inp-modBCST').val('').change()
        $('#inp-pICMSST').val('')
        $('#inp-pMVAST').val('')
        $('#inp-redBCST').val('')
    }
});

function changeDericadoPetroleo() {
    let check = $('#inp-petroleo').is(':checked')
    if (check) {
        $('.div-petroleo').removeClass('d-none')
    } else {
        $('.div-petroleo').addClass('d-none')
    }
}

$('#inp-petroleo').change(() => {
    console.log('Checkbox petróleo mudou:', $('#inp-petroleo').is(':checked'));
    changeDericadoPetroleo()
})

function changeCardapio() {
    let check = $('#inp-cardapio').is(':checked')
    if (check) {
        $('.div-cardapio').removeClass('d-none')
    } else {
        $('.div-cardapio').addClass('d-none')
    }
}

$('#inp-cardapio').change(() => {
    console.log('Checkbox cardápio mudou:', $('#inp-cardapio').is(':checked'));
    changeCardapio()
})

function changeNuvemShop() {
    let check = $('#inp-nuvemshop').is(':checked')
    if (check) {
        $('.div-nuvemshop').removeClass('d-none')
        $('.inp-nuvemshop').attr('required', 1)
    } else {
        $('.div-nuvemshop').addClass('d-none')
        $('.inp-nuvemshop').removeAttr('required')
    }
}

$('#inp-nuvemshop').change(() => {
    changeNuvemShop()
})

function changeDelivery() {
    let check = $('#inp-delivery').is(':checked')
    if (check) {
        $('.div-delivery').removeClass('d-none')
    } else {
        $('.div-delivery').addClass('d-none')
    }
}

$('#inp-delivery').change(() => {
    console.log('Checkbox delivery mudou:', $('#inp-delivery').is(':checked'));
    changeDelivery()
})

function changeEcommerce() {
    let check = $('#inp-ecommerce').is(':checked')
    if (check) {
        $('.div-ecommerce').removeClass('d-none')
    } else {
        $('.div-ecommerce').addClass('d-none')
    }
}

$('#inp-ecommerce').change(() => {
    changeEcommerce()
})

function changeWoocommerce() {
    let check = $('#inp-woocommerce').is(':checked')
    if (check) {
        $('.div-woocommerce').removeClass('d-none')
        $('.inp-woocommerce').attr('required', 1)
    } else {
        $('.div-woocommerce').addClass('d-none')
        $('.inp-woocommerce').removeAttr('required')
    }
}

$('#inp-woocommerce').change(() => {
    changeWoocommerce()
})

function changeMeradoLivre() {
    let check = $('#inp-mercadolivre').is(':checked')
    if (check) {
        $('.div-mercadolivre').removeClass('d-none')
        $('.input-ml').attr('required', 1)
        getTiposPublicacao()
    } else {
        $('.div-mercadolivre').addClass('d-none')
        $('.input-ml').removeAttr('required')
    }
}

function getTiposPublicacao(){

    $.get(path_url + "api/mercadolivre/get-tipo-publicacao", {
        empresa_id: $('#empresa_id').val()
    })
    .done((res) => {
        if(res.code == 'unauthorized'){
            return;
        }
        $('#inp-mercado_livre_tipo_publicacao').html('')
        var newOption = new Option('Selecione', '', false, false);
        $('#inp-mercado_livre_tipo_publicacao').append(newOption);
        res.map((x) => {
            var newOption = new Option(x.name, x.id, false, false);
            $('#inp-mercado_livre_tipo_publicacao').append(newOption);
        })

        setTimeout(() => {
            $('#inp-mercado_livre_tipo_publicacao').val($('#tipo_publicacao_hidden').val()).change()
        }, 100)
    })
    .fail((err) => {
        console.log(err)
        swal("Erro", "Algo deu errado", "error")
    })
}
$('#inp-mercadolivre').change(() => {
    changeMeradoLivre()
})

$(document).ready(function() {
    $("form").bind("keypress", function(e) {
        if (e.keyCode == 13) {
            return false;
        }
    });

    // Fix adicional para checkboxes - forçar funcionalidade
    $('.form-check-input').each(function() {
        var $checkbox = $(this);
        var $label = $checkbox.closest('.form-check').find('strong');
        
        // Tornar o label clicável
        $label.on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            $checkbox.prop('checked', !$checkbox.prop('checked')).trigger('change');
            console.log('Label clicado para:', $checkbox.attr('id'), 'novo estado:', $checkbox.is(':checked'));
        });
    });
});

function changeVariavel() {
    let variavel = $('#inp-variavel').val()
    if (variavel == 1) {
        $('.div-variavel').removeClass('d-none')
        $('#inp-valor_unitario').val('0')
        //$('#inp-valor_compra').val('0')
    } else {
        $('.div-variavel').addClass('d-none')
    }
}

$('#inp-variavel').change(() => {
    changeVariavel()
})

function changeCombo() {
    let variavel = $('#inp-combo').val()
    if (variavel == 1) {
        $('.div-combo').removeClass('d-none')
    } else {
        $('.div-combo').addClass('d-none')
    }
}

$('#inp-combo').change(() => {
    changeCombo()
})

// variacoes

$(document).on("change", "#inp-variacao_modelo_id", function () {

    let variacao_modelo_id = $(this).val()
    if(variacao_modelo_id){
        $.get(path_url + "api/variacoes/modelo", {
            variacao_modelo_id: variacao_modelo_id
        })
        .done((res) => {
            $('.table-variacao tbody').html(res)
            $('#inp-sub_variacao_modelo_id').val('').change()
        })
        .fail((err) => {
            console.log(err)
            swal("Erro", "Algo deu errado", "error")
        })
    }
})
$(document).on("change", "#inp-sub_variacao_modelo_id", function () {

    let sub_variacao_modelo_id = $(this).val()
    let variacao_modelo_id = $('#inp-variacao_modelo_id').val()
    if(!sub_variacao_modelo_id) return;
    if(variacao_modelo_id){
        $.get(path_url + "api/variacoes/modelo-subvariacoes", {
            variacao_modelo_id: variacao_modelo_id,
            sub_variacao_modelo_id: sub_variacao_modelo_id
        })
        .done((res) => {
            $('.table-variacao tbody').html(res)
        })
        .fail((err) => {
            console.log(err)
            swal("Erro", "Algo deu errado", "error")
        })
    }else{
        swal("Erro", "Selecione a variação principal primeiro!", "error")
    }
})

$(document).on("blur", "#inp-valor_compra", function () {
    let valorCompra = convertMoedaToFloat($(this).val())
    $percLucro = $(this).closest('.col-produto').next().find('input');
    $valorUnitario = $(this).closest('.col-produto').next().next().find('input');
    
    if($percLucro.val()){
        let valor = valorCompra + ((valorCompra*$percLucro.val())/100)
        $valorUnitario.val(convertFloatToMoeda(valor))
    }
})

$(document).on("blur", "#inp-percentual_lucro", function () {
    let percLucro = $(this).val()
    $valorCompra = $(this).closest('.col-produto').prev().find('input');
    $valorUnitario = $(this).closest('.col-produto').next().find('input');
    if($valorCompra.val()){
        let vlCompra = convertMoedaToFloat($valorCompra.val())

        let valor = vlCompra + ((vlCompra*percLucro)/100)
        $valorUnitario.val(convertFloatToMoeda(valor))
    }
})

$(document).on("blur", "#inp-valor_unitario", function () {
    let valorUnitario = convertMoedaToFloat($(this).val())
    $percLucro = $(this).closest('.col-produto').prev().find('input');

    $valorCompra = $(this).closest('.col-produto').prev().prev().find('input');
    if($valorCompra.val() && valorUnitario){
        let vlCompra = convertMoedaToFloat($valorCompra.val())
        let dif = (valorUnitario - vlCompra)/vlCompra*100;
        $percLucro.val(dif.toFixed(2))
    }else{
        $percLucro.val('0')
    }
})

$(document).on("blur", ".valor-compra-combo", function () {
    let valorCompra = convertMoedaToFloat($(this).val())
    $subtotal = $(this).closest('td').next().find('input');
    $qtd = $(this).closest('td').prev().find('input');
    let qtd = $qtd.val()

    $subtotal.val(convertFloatToMoeda(valorCompra * qtd))
    calcValorCombo()
})

$(document).on("blur", ".qtd-combo", function () {
    let qtd = $(this).val()
    $subtotal = $(this).closest('td').next().next().find('input');
    $valorCompra = $(this).closest('td').next().find('input');
    let valorCompra = convertMoedaToFloat($valorCompra.val())

    $subtotal.val(convertFloatToMoeda(valorCompra * qtd))
    calcValorCombo()
})

$(document).on("blur", "#inp-margem_combo", function () {
    calcValorCombo()
})

function calcValorCombo(){
    let totalCombo = 0
    let margem = $('#inp-margem_combo').val()
    $(".subtotal-combo").each(function () {
        totalCombo += convertMoedaToFloat($(this).val())
    })
    $('#inp-valor_compra').val(convertFloatToMoeda(totalCombo))
    totalCombo += (totalCombo*(parseFloat(margem)/100))
    setTimeout(() => {
        $('#inp-valor_combo').val(convertFloatToMoeda(totalCombo))
        $('#inp-valor_unitario').val(convertFloatToMoeda(totalCombo))
    }, 100)

}
$(document).on("blur", "#inp-valor_unitario", function () {
    $('#inp-nuvem_shop_valor').val($(this).val())
})
$(document).on("change", "#inp-produto_combo_id", function () {
    let produto_id = $(this).val()
    if(produto_id){
        $.get(path_url + "api/combos/modelo", {
            produto_id: produto_id
        })
        .done((res) => {
            $("#inp-produto_combo_id").val('').change()
            $('.table-combo tbody').append(res)
            setTimeout(() => {
                calcValorCombo()
            }, 10)
        })
        .fail((err) => {
            console.log(err)
            swal("Erro", "Algo deu errado", "error")
        })
    }
})

$(document).delegate(".btn-remove-tr-variacao", "click", function (e) {
    e.preventDefault();
    swal({
        title: "Você esta certo?",
        text: "Deseja remover esse item mesmo?",
        icon: "warning",
        buttons: true
    }).then(willDelete => {
        if (willDelete) {
            var trLength = $(this)
            .closest("tr")
            .closest("tbody")
            .find("tr")
            .not(".dynamic-form-document").length;
            if (!trLength || trLength > 1) {
                $(this)
                .closest("tr")
                .remove();
            } else {
                swal("Atenção", "Você deve ter ao menos um item na lista", "warning");
            }
        }
    });
});

$(document).delegate(".btn-remove-tr-combo", "click", function (e) {
    e.preventDefault();
    swal({
        title: "Você esta certo?",
        text: "Deseja remover esse item mesmo?",
        icon: "warning",
        buttons: true
    }).then(willDelete => {
        if (willDelete) {

            $(this).closest("tr").remove();
            calcValorCombo()
        }
    });
});


$('.btn-add-tr-variacao').on("click", function () {
    console.clear()
    var $table = $(this)
    .closest(".row")
    .prev()
    .find(".table-variacao");

    console.log($table)

    var hasEmpty = false;

    $table.find("input, select").each(function () {
        if (($(this).val() == "" || $(this).val() == null) && $(this).attr("type") != "hidden" && $(this).attr("type") != "file" && !$(this).hasClass("ignore")) {
            hasEmpty = true;
        }
    });

    if (hasEmpty) {
        swal(
            "Atenção",
            "Preencha todos os campos antes de adicionar novos.",
            "warning"
            );
        return;
    }
    // $table.find("select.select2").select2("destroy");
    var $tr = $table.find(".dynamic-form").first();
    $tr.find("select.select2").select2("destroy");
    var $clone = $tr.clone();
    $clone.show();

    $clone.find("input,select").val("");
    $clone.find("input,select").removeAttr('readonly');
    $table.append($clone);
    setTimeout(function () {
        $("tbody select.select2").select2({
            language: "pt-BR",
            width: "100%",
            theme: "bootstrap4"
        });
    }, 100);

})

// Função para calcular progresso de preenchimento
function calcularProgresso() {
    let camposObrigatorios = $("body #form-produto").find('input[required], select[required]');
    let camposPreenchidos = 0;
    let totalCampos = camposObrigatorios.length;
    
    camposObrigatorios.each(function() {
        if ($(this).val() && $(this).val() !== "") {
            camposPreenchidos++;
        }
    });
    
    let percentual = totalCampos > 0 ? Math.round((camposPreenchidos / totalCampos) * 100) : 0;
    
    // Atualiza o indicador de progresso
    $('#progress-fill').css('width', percentual + '%');
    $('#progress-text').text(percentual + '% completo (' + camposPreenchidos + '/' + totalCampos + ' campos)');
    
    // Mostra o indicador se há campos obrigatórios
    if (totalCampos > 0) {
        $('#progress-indicator').show();
    }
    
    // Muda a cor baseada no percentual
    if (percentual === 100) {
        $('#progress-fill').css('background-color', '#28a745');
        $('#progress-text').text('✅ Formulário completo!');
    } else if (percentual >= 70) {
        $('#progress-fill').css('background-color', '#17a2b8');
    } else if (percentual >= 40) {
        $('#progress-fill').css('background-color', '#ffc107');
    } else {
        $('#progress-fill').css('background-color', '#dc3545');
    }
}

// Função para validar campos em tempo real
function validarCampoEmTempoReal() {
    $("body #form-produto").find('input[required], select[required]').on('blur change', function() {
        let campo = $(this);
        let valor = campo.val();
        
        if (valor == "" || valor == null) {
            campo.addClass('is-invalid');
            campo.removeClass('is-valid');
            
            // Adiciona tooltip de ajuda
            if (!campo.attr('title')) {
                campo.attr('title', 'Este campo é obrigatório');
            }
        } else {
            campo.removeClass('is-invalid');
            campo.addClass('is-valid');
        }
        
        // Atualiza o progresso
        calcularProgresso();
    });
}

// Função para mostrar dicas de preenchimento
function mostrarDicasPreenchimento() {
    let dicas = {
        'nome': 'Digite o nome completo do produto',
        'valor_compra': 'Valor que você paga pelo produto',
        'percentual_lucro': 'Percentual de lucro desejado sobre o produto',
        'valor_unitario': 'Valor de venda do produto (será calculado automaticamente)',
        'unidade': 'Unidade de medida do produto (UN, KG, L, etc.)',
        'ncm': 'Classificação fiscal do produto (consulte a tabela NCM)',
        'origem': 'Origem do produto (0-Nacional, 1-Estrangeiro, etc.)'
    };
    
    Object.keys(dicas).forEach(function(campo) {
        let elemento = $("body #form-produto").find('[name="' + campo + '"]');
        if (elemento.length) {
            elemento.attr('title', dicas[campo]);
        }
    });
}

// Função para verificar se o plano fiscal está ativo
function verificarPlanoFiscal() {
    $.get(path_url + "api/empresa/plano-fiscal")
    .done((result) => {
        if (result.fiscal) {
            toastr.info('Seu plano inclui funcionalidades fiscais. Os campos fiscais são obrigatórios.', 'Informação');
        }
    })
    .fail((err) => {
        console.log('Erro ao verificar plano fiscal:', err);
    });
}

// Inicializa as validações quando o documento estiver pronto
$(document).ready(function() {
    validarCampoEmTempoReal();
    mostrarDicasPreenchimento();
    verificarPlanoFiscal();
    calcularProgresso(); // Calcula o progresso inicial
});
