$(document).ready(function(){
    console.log('=== ESTOQUE.JS DEBUG ===');
    console.log('Documento carregado');
    console.log('jQuery version:', $.fn.jquery);
    console.log('Select2 disponível:', typeof $.fn.select2 !== 'undefined');
    console.log('path_url:', typeof path_url !== 'undefined' ? path_url : 'UNDEFINED');
    console.log('Elemento #inp-produto_id encontrado:', $('#inp-produto_id').length);
    
    // Verificar se o elemento existe antes de inicializar
    if ($('#inp-produto_id').length === 0) {
        console.error('ERRO: Elemento #inp-produto_id não encontrado!');
        return;
    }
    
    if (typeof $.fn.select2 === 'undefined') {
        console.error('ERRO: Select2 não está carregado!');
        return;
    }
    
    if (typeof path_url === 'undefined') {
        console.error('ERRO: path_url não está definido!');
        return;
    }
    
    console.log('Inicializando Select2 para #inp-produto_id...');
    
    try {
        // Inicialização do select2 para produtos na página de estoque
        $("#inp-produto_id").select2({
            minimumInputLength: 2,
            language: "pt-BR",
            placeholder: "Digite para buscar o produto",
            width: "100%",
            theme: "bootstrap4",
            ajax: {
                cache: true,
                url: path_url + "api/produtos/search",
                dataType: "json",
                data: function (params) {
                    console.log('Fazendo requisição AJAX com params:', params);
                    let empresa_id = $('#empresa_id').val()
                    var query = {
                        term: params.term,
                        empresa_id: empresa_id
                    };
                    console.log('Query enviada:', query);
                    return query;
                },
                processResults: function (response) {
                    console.log('Resposta da API recebida:', response);
                    
                    // A rota web retorna um objeto com 'results', não um array direto
                    if (response.results) {
                        console.log('Resultados processados:', response.results);
                        return {
                            results: response.results.map(function(item) {
                                return {
                                    id: item.id,
                                    text: item.text,
                                    value: item.id
                                };
                            })
                        };
                    }
                    
                    // Fallback para formato antigo (caso ainda seja necessário)
                    var results = [];
                    let compra = 0
                    if($('#is_compra') && $('#is_compra').val() == 1){
                        compra = 1
                    }

                    $.each(response, function (i, v) {
                        var o = {};
                        o.id = v.id;
                        if(v.codigo_variacao){
                            o.codigo_variacao = v.codigo_variacao
                        }

                        o.text = v.nome
                        if(compra == 0){
                            if(parseFloat(v.valor_unitario) > 0){
                                o.text += ' R$ ' + convertFloatToMoeda(v.valor_unitario);
                            }
                        }else{
                            o.text += ' R$ ' + convertFloatToMoeda(v.valor_compra);
                        }
                        if(v.codigo_barras){
                            o.text += ' [' + v.codigo_barras  + ']';
                        }
                        o.value = v.id;
                        results.push(o);
                    });
                    console.log('Resultados processados:', results);
                    return {
                        results: results,
                    };
                },
                error: function(xhr, status, error) {
                    console.error('ERRO na requisição AJAX:', {
                        status: status,
                        error: error,
                        response: xhr.responseText
                    });
                }
            },
        });
        
        console.log('Select2 inicializado com sucesso!');
        
    } catch (error) {
        console.error('ERRO ao inicializar Select2:', error);
    }

    // Event handler para quando o produto for selecionado
    $(document).on('change', '#inp-produto_id', function() {
        let product_id = $(this).val()
        if (product_id) {
            // Buscar informações do produto
            $.get(path_url + "api/produtos/find", {
                produto_id: product_id,
                local_id: $('#local_id').val(),
                usuario_id: $('#usuario_id').val()
            })
            .done((e) => {
                let codigo_variacao = $(this).select2('data')[0].codigo_variacao      

                if(e.variacao_modelo_id > 0 && !codigo_variacao){
                    buscarVariacoes(product_id)
                }

                if(codigo_variacao > 0){
                    $('#produto_variacao_id').val(codigo_variacao)
                }

                // Mostrar informações do produto
                if ($('#produto-info').length) {
                    $('#produto-info').show()
                    $('#produto-nome').text(e.nome || '-')
                    $('#produto-codigo').text(e.codigo_barras || '-')
                    $('#produto-categoria').text(e.categoria ? e.categoria.nome : '-')
                    $('#estoque-atual').text(e.estoque_atual || '0')
                }
            })
            .fail((err) => {
                console.log(err)
            })
        }
    })

    // Atualizar informações quando mudar o local
    $(document).on("change", "#local_id", function () {
        let product_id = $('#inp-produto_id').val()
        if (product_id) {
            $('#inp-produto_id').trigger('change')
        }
    })

    // Validar quantidade quando mudar tipo de movimentação ou quantidade
    $(document).on("change", "#tipo_movimentacao, input[name='quantidade']", function () {
        let tipo = $('#tipo_movimentacao').val()
        let quantidade = parseFloat($('input[name="quantidade"]').val()) || 0
        let estoque_atual = parseFloat($('#estoque-atual').text().replace(/\./g, '').replace(',', '.')) || 0
        
        // comentado- bug la do view o obj nao retorno o estoque
        
        // if (tipo === 'saida' && quantidade > estoque_atual) {
        //     swal("Atenção!", "Quantidade de saída maior que o estoque disponível!", "warning")
        //     $('input[name="quantidade"]').val('')
        // }
    })

    function buscarVariacoes(produto_id){
        $.get(path_url + "api/variacoes/find", { produto_id: produto_id })
        .done((res) => {
            $('#modal_variacao .modal-body').html(res)
            $('#modal_variacao').modal('show')
        })
        .fail((err) => {
            console.log(err)
            swal("Algo deu errado", "Erro ao buscar variações", "error")
        })
    }

    function selecionarVariacao(id, descricao, valor){
        $('#produto_variacao_id').val(id)
        $('#modal_variacao').modal('hide')
    }
});