<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Produto;
use App\Models\ProdutoLocalizacao;
use App\Models\Localizacao;
use App\Models\Caixa;

echo "=== DEBUG LOCALIZAÇÃO ===\n";

// Verificar localizações da empresa
$localizacoes = Localizacao::where('empresa_id', 1)->where('status', 1)->get();
echo "Localizações ativas da empresa 1: " . $localizacoes->count() . "\n";
foreach ($localizacoes as $loc) {
    echo "- ID: {$loc->id}, Nome: {$loc->nome}\n";
}

// Verificar produto_localizacaos
$produto = Produto::where('empresa_id', 1)->first();
if ($produto) {
    echo "\nProduto: {$produto->nome} (ID: {$produto->id})\n";
    
    $produtoLocs = ProdutoLocalizacao::where('produto_id', $produto->id)->get();
    echo "Localizações do produto: " . $produtoLocs->count() . "\n";
    foreach ($produtoLocs as $pl) {
        echo "- Localização ID: {$pl->localizacao_id}\n";
    }
    
    // Verificar caixa do usuário
    $caixa = Caixa::where('usuario_id', 1)->where('status', 1)->first();
    if ($caixa) {
        echo "\nCaixa do usuário 1: Local ID {$caixa->local_id}\n";
    } else {
        echo "\nNenhum caixa ativo para usuário 1\n";
    }
    
    // Simular a query da API com local_id
    echo "\n=== SIMULANDO QUERY DA API ===\n";
    
    // Primeiro, vamos ver qual local_id seria usado
    $local_id = null;
    if ($caixa != null) {
        $local_id = $caixa->local_id;
    }
    
    echo "Local ID que seria usado: " . ($local_id ?? 'null') . "\n";
    
    // Query sem filtro de localização
    $query1 = Produto::orderBy('nome', 'desc')
        ->select('produtos.*')
        ->where('empresa_id', 1)
        ->where('status', 1)
        ->where('nome', 'LIKE', "%CABO%");
        
    echo "Produtos sem filtro de localização: " . $query1->count() . "\n";
    
    // Query com filtro de localização (se houver)
    if ($local_id != null) {
        $query2 = Produto::orderBy('nome', 'desc')
            ->select('produtos.*')
            ->where('empresa_id', 1)
            ->where('status', 1)
            ->where('nome', 'LIKE', "%CABO%")
            ->join('produto_localizacaos', 'produto_localizacaos.produto_id', '=', 'produtos.id')
            ->where('produto_localizacaos.localizacao_id', $local_id)
            ->distinct('produtos.id');
            
        echo "Produtos com filtro de localização (local_id: $local_id): " . $query2->count() . "\n";
    }
}