<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;

class OrdemProducaoPermissionSeeder extends Seeder
{
    public function run(): void
    {
        $perms = [
            ['name' => 'ordem_producao_view', 'description' => 'Visualiza ordem de produção'],
            ['name' => 'ordem_producao_create', 'description' => 'Cria ordem de produção'],
            ['name' => 'ordem_producao_edit', 'description' => 'Edita ordem de produção'],
            ['name' => 'ordem_producao_delete', 'description' => 'Deleta ordem de produção'],
        ];

        // Garante que permissões existam/atualizem descrição
        foreach ($perms as $p) {
            Permission::updateOrCreate(['name' => $p['name']], $p);
        }

        // Atribui para papéis padrão
        $roles = Role::whereIn('name', ['admin', 'gestor_plataforma'])->get();
        $permissions = Permission::whereIn('name', array_column($perms, 'name'))->get();

        foreach ($roles as $role) {
            $role->permissions()->syncWithoutDetaching($permissions->pluck('id')->toArray());
        }
    }
}
