<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('ordem_producaos', function (Blueprint $table) {
            if (!Schema::hasColumn('ordem_producaos', 'situacao')) {
                $table->string('situacao', 30)->default('em_producao')->after('estado');
            }
            if (!Schema::hasColumn('ordem_producaos', 'data_producao')) {
                $table->date('data_producao')->nullable()->after('situacao');
            }
            if (!Schema::hasColumn('ordem_producaos', 'cliente_id')) {
                $table->foreignId('cliente_id')->nullable()->constrained('clientes')->after('empresa_id');
            }
            if (!Schema::hasColumn('ordem_producaos', 'created_by')) {
                $table->foreignId('created_by')->nullable()->constrained('users')->after('codigo_sequencial');
            }
            if (!Schema::hasColumn('ordem_producaos', 'finished_by')) {
                $table->foreignId('finished_by')->nullable()->constrained('users')->after('created_by');
            }
            if (!Schema::hasColumn('ordem_producaos', 'finished_at')) {
                $table->dateTime('finished_at')->nullable()->after('finished_by');
            }
        });

        // Migrar valores existentes de 'estado' para 'situacao' quando possível
        // novo/producao/expedicao/entregue -> em_producao (padrão) para compatibilidade
        try {
            \DB::statement("UPDATE ordem_producaos SET situacao = 'em_producao' WHERE situacao IS NULL OR situacao = ''");
        } catch (\Throwable $e) {
            // ignore em caso de erro durante deploy inicial
        }
    }

    public function down(): void
    {
        Schema::table('ordem_producaos', function (Blueprint $table) {
            if (Schema::hasColumn('ordem_producaos', 'finished_at')) {
                $table->dropColumn('finished_at');
            }
            if (Schema::hasColumn('ordem_producaos', 'finished_by')) {
                $table->dropConstrainedForeignId('finished_by');
            }
            if (Schema::hasColumn('ordem_producaos', 'created_by')) {
                $table->dropConstrainedForeignId('created_by');
            }
            if (Schema::hasColumn('ordem_producaos', 'cliente_id')) {
                $table->dropConstrainedForeignId('cliente_id');
            }
            if (Schema::hasColumn('ordem_producaos', 'data_producao')) {
                $table->dropColumn('data_producao');
            }
            if (Schema::hasColumn('ordem_producaos', 'situacao')) {
                $table->dropColumn('situacao');
            }
        });
    }
};
