<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCupomConfigToConfigGeralsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('config_gerals', function (Blueprint $table) {
            $table->integer('largura_cupom')->default(72)->after('tipo_menu');
            $table->integer('margem_cupom')->default(2)->after('largura_cupom');
            $table->string('fonte_cupom', 20)->default('arial')->after('margem_cupom');
            $table->boolean('cupom_imprimir_resumo')->default(false)->after('fonte_cupom');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('config_gerals', function (Blueprint $table) {
            $table->dropColumn('largura_cupom');
            $table->dropColumn('margem_cupom');
            $table->dropColumn('fonte_cupom');
            $table->dropColumn('cupom_imprimir_resumo');
        });
    }
} 