<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('taxa_historico')) {
            Schema::create('taxa_historico', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('empresa_id');
                $table->unsignedBigInteger('taxa_pagamento_id');
                $table->decimal('taxa_anterior', 10, 2)->nullable();
                $table->decimal('taxa_nova', 10, 2);
                $table->string('tipo_pagamento', 50);
                $table->string('bandeira_cartao', 20)->nullable();
                $table->unsignedBigInteger('usuario_id')->nullable();
                $table->timestamps();

                // Chaves estrangeiras
                $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('cascade');
                $table->foreign('taxa_pagamento_id')->references('id')->on('taxa_pagamentos')->onDelete('cascade');
                $table->foreign('usuario_id')->references('id')->on('users')->onDelete('set null');
                
                // Índices para otimização
                $table->index('tipo_pagamento');
                $table->index('bandeira_cartao');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('taxa_historico');
    }
}; 