<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('conta_recebers')) {
            Schema::table('conta_recebers', function (Blueprint $table) {
                // Verificar se os campos já existem antes de adicioná-los
                if (!Schema::hasColumn('conta_recebers', 'data_vencimento_original')) {
                    $table->date('data_vencimento_original')->nullable();
                }
                
                if (!Schema::hasColumn('conta_recebers', 'data_nova_vencimento')) {
                    $table->date('data_nova_vencimento')->nullable();
                }
                
                if (!Schema::hasColumn('conta_recebers', 'juros_aplicados')) {
                    $table->decimal('juros_aplicados', 10, 2)->default(0);
                }
                
                if (!Schema::hasColumn('conta_recebers', 'multa_aplicada')) {
                    $table->decimal('multa_aplicada', 10, 2)->default(0);
                }
                
                // Campos para reparcelamento
                if (!Schema::hasColumn('conta_recebers', 'total_parcelas')) {
                    $table->integer('total_parcelas')->nullable();
                }
                
                if (!Schema::hasColumn('conta_recebers', 'parcela_atual')) {
                    $table->integer('parcela_atual')->nullable();
                }
                
                if (!Schema::hasColumn('conta_recebers', 'parent_id')) {
                    $table->unsignedBigInteger('parent_id')->nullable();
                    $table->foreign('parent_id')->references('id')->on('conta_recebers')->onDelete('set null');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('conta_recebers')) {
            Schema::table('conta_recebers', function (Blueprint $table) {
                // Não remover os campos em produção para evitar perda de dados
                // Se necessário, remova os campos manualmente com cuidado
            });
        }
    }
};
