<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventarios', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empresa_id')->nullable();
            $table->unsignedBigInteger('usuario_id')->nullable();
            $table->date('inicio');
            $table->date('fim');
            $table->datetime('data_ajuste')->nullable();
            $table->boolean('status');
            $table->string('referencia', 30);
            $table->string('observacao', 255)->nullable();
            $table->string('tipo', 15);
            $table->integer('numero_sequencial')->nullable();
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('restrict');
            $table->foreign('usuario_id')->references('id')->on('users')->onDelete('restrict');
            
            // Indexes
            $table->index('empresa_id');
            $table->index('usuario_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventarios');
    }
};