<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('devolucoes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empresa_id');
            $table->unsignedBigInteger('usuario_id');
            $table->unsignedBigInteger('venda_id'); // Can reference nves or nfces based on tipo_venda
            $table->string('tipo_venda', 10)->default('nfce'); // 'nfe' or 'nfce'
            $table->unsignedBigInteger('cliente_id');
            $table->decimal('total', 10, 2)->default(0.00);
            $table->decimal('desconto', 10, 2)->default(0.00);
            $table->text('observacoes')->nullable();
            $table->enum('status', ['pendente', 'processada', 'cancelada'])->default('pendente');
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('cascade');
            $table->foreign('usuario_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('cliente_id')->references('id')->on('clientes')->onDelete('cascade');
            
            // Indexes
            $table->index(['empresa_id', 'status']);
            $table->index('venda_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('devolucoes');
    }
};