<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->unsignedBigInteger('pais_id')->nullable()->after('cidade_id');
            $table->string('cod_pais', 8)->nullable()->after('pais_id');
            $table->string('nome_pais', 100)->nullable()->after('cod_pais');
            
            $table->foreign('pais_id')->references('id')->on('paises')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->dropForeign(['pais_id']);
            $table->dropColumn(['pais_id', 'cod_pais', 'nome_pais']);
        });
    }
};