<?php

namespace App\Observers;

use App\Models\Nfce;
use App\Models\TaxaPagamento;

class NfceTaxaObserver
{
    /**
     * Handle the Nfce "created" event.
     */
    public function created(Nfce $nfce)
    {
        if (!empty($nfce->tipo_pagamento) && !empty($nfce->empresa_id)) {
            $bandeira_cartao = $nfce->bandeira_cartao;
            
            $taxa = TaxaPagamento::where('empresa_id', $nfce->empresa_id)
                ->where('tipo_pagamento', $nfce->tipo_pagamento)
                ->when($bandeira_cartao != '' && $bandeira_cartao != '99', function ($q) use ($bandeira_cartao) {
                    return $q->where('bandeira_cartao', $bandeira_cartao);
                })
                ->first();
                
            if ($taxa) {
                $nfce->taxa_percentual = $taxa->taxa;
                $nfce->save();
            }
        }
    }
} 