<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Devolucao extends Model
{
    use HasFactory;
    
    protected $table = 'devolucoes';
    
    protected $fillable = [
        'empresa_id',
        'usuario_id',
        'venda_id',
        'tipo_venda', // 'nfe' ou 'nfce'
        'total',
        'tipo_pagamento',
        'cliente_id',
        'observacao',
        'data_devolucao',
        'is_troca',
        'valor_diferenca',
        'caixa_id'
    ];
    
    protected $casts = [
        'data_devolucao' => 'datetime'
    ];
    
    // Relacionamentos
    public function itens()
    {
        return $this->hasMany(ItemDevolucao::class, 'devolucao_id');
    }
    
    public function usuario()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }
    
    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }
    
    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }
    
    public function caixa()
    {
        return $this->belongsTo(Caixa::class, 'caixa_id');
    }
} 