<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Produto;
use App\Models\ConfigGeral;

class OrcamentoController extends Controller
{
    public function validaDesconto(Request $request){
        $item = Produto::findOrFail($request->produto_id);
        // Normaliza o valor recebido (pode vir como "22,90", "22.90" ou vazio)
        $valor = $request->valor;
        if ($valor === null || $valor === '') {
            // Nada para validar
            return response()->json("ok", 200);
        }
        if (!is_numeric($valor)) {
            try {
                $valor = __convert_value_bd($valor);
            } catch (\Throwable $t) {
                // Se não conseguir converter, evita travar a venda
                return response()->json("ok", 200);
            }
        } else {
            $valor = (float)$valor;
        }

        if($item->valor_minimo_venda > 0){
            $minimo = (float)$item->valor_minimo_venda;
            $vNorm = round((float)$valor, 2);
            $mNorm = round($minimo, 2);
            \Log::info('[PDV][validaDesconto] produto_id='.$item->id.' valor_normalizado='.$vNorm.' minimo='.$mNorm);
            if($vNorm + 0.00001 < $mNorm){
                \Log::warning('[PDV][validaDesconto][FAIL] abaixo do mínimo: valor='.$vNorm.' minimo='.$mNorm);
                return response()->json($mNorm, 401);
            }
        }

        if(isset($request->pdv)){
            return response()->json("ok", 200);
        }

        $config = ConfigGeral::where('empresa_id', $request->empresa_id)->first();
        if($config != null && $config->percentual_desconto_orcamento > 0){
            $v = $item->valor_unitario - $item->valor_compra;
            $valorMinimo = $item->valor_unitario - ($v*($config->percentual_desconto_orcamento/100));

            if($valor < $valorMinimo){
                return response()->json($valorMinimo, 401);
            }
            return response()->json("ok", 200);
        }
        return response()->json("ok", 200);
    }

}
