<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Verificar se o usuário é admin
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    header("Location: lancamentos.php");
    exit();
}

require_once 'config/database.php';
$database = new Database();
$db = $database->getConnection();

// Buscar usuários
$query = "SELECT * FROM usuarios ORDER BY nome";
$stmt = $db->prepare($query);
$stmt->execute();
$usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Definir título da página
$titulo = "Usuários";

// Conteúdo da página
ob_start();
?>

<!-- Modal de Usuário -->
<div class="modal fade" id="usuarioModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Usuário</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="usuarioForm" method="POST">
                    <input type="hidden" name="action" value="criar">
                    <input type="hidden" name="id" value="">
                    
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome</label>
                        <input type="text" class="form-control" id="nome" name="nome" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="email" class="form-label">E-mail</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="senha" class="form-label">Senha</label>
                        <input type="password" class="form-control" id="senha" name="senha">
                        <small class="form-text text-muted">Deixe em branco para manter a senha atual ao editar.</small>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="admin" name="admin">
                            <label class="form-check-label" for="admin">Administrador</label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="submit" form="usuarioForm" class="btn btn-primary">Salvar</button>
            </div>
        </div>
    </div>
</div>

<!-- Conteúdo Principal -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Usuários</h5>
        <button type="button" class="btn btn-primary" onclick="novoUsuario()">
            Novo Usuário
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table" id="usuariosTable">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>E-mail</th>
                        <th>Admin</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($usuarios as $usuario): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($usuario['nome']); ?></td>
                            <td><?php echo htmlspecialchars($usuario['email']); ?></td>
                            <td>
                                <span class="badge <?php echo $usuario['admin'] ? 'bg-primary' : 'bg-secondary'; ?>">
                                    <?php echo $usuario['admin'] ? 'Sim' : 'Não'; ?>
                                </span>
                            </td>
                            <td>
                                <span class="badge <?php echo $usuario['ativo'] ? 'bg-success' : 'bg-danger'; ?>">
                                    <?php echo $usuario['ativo'] ? 'Ativo' : 'Inativo'; ?>
                                </span>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-sm btn-primary" onclick='editarUsuario(<?php echo json_encode($usuario); ?>)'>
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <?php if ($usuario['ativo'] && $usuario['id'] != $_SESSION['user_id']): ?>
                                        <button type="button" class="btn btn-sm btn-danger" onclick='desativarUsuario(<?php echo $usuario["id"]; ?>)'>
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();

// JavaScript adicional
$extra_js = '
<script>
$(document).ready(function() {
    // Inicializar DataTable
    $("#usuariosTable").DataTable({
        // Configurar o idioma para Português do Brasil
        language: {
            url: "//cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json"
        },
        // Definir a ordem padrão como nome crescente
        order: [[0, "asc"]],
        // Configurar o número de registros por página
        pageLength: 5,
        // Opções de quantidade de registros por página
        lengthMenu: [[5, 10, 25, 50], [5, 10, 25, 50]]
    });
});

function novoUsuario() {
    $("#usuarioForm")[0].reset();
    $("#usuarioForm [name=action]").val("criar");
    $("#usuarioForm [name=id]").val("");
    $("#senha").attr("required", true);
    $("#usuarioModal").modal("show");
}

function editarUsuario(usuario) {
    $("#usuarioForm")[0].reset();
    $("#usuarioForm [name=action]").val("editar");
    $("#usuarioForm [name=id]").val(usuario.id);
    $("#nome").val(usuario.nome);
    $("#email").val(usuario.email);
    $("#admin").prop("checked", usuario.admin == 1);
    $("#senha").attr("required", false);
    $("#usuarioModal").modal("show");
}

function desativarUsuario(id) {
    if (confirm("Tem certeza que deseja desativar este usuário?")) {
        const form = document.createElement("form");
        form.method = "POST";
        form.innerHTML = `
            <input type="hidden" name="action" value="desativar">
            <input type="hidden" name="id" value="${id}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
';

// Incluir o layout
require_once 'includes/layout.php';
?>
