-- Create database
CREATE DATABASE IF NOT EXISTS livro_caixa;
USE livro_caixa;

-- Tabela de usuários
CREATE TABLE IF NOT EXISTS usuarios (
    id INT PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    senha VARCHAR(255) NOT NULL,
    admin BOOLEAN DEFAULT FALSE,
    ativo BOOLEAN DEFAULT TRUE,
    data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabela de formas de pagamento
CREATE TABLE IF NOT EXISTS formas_pagamento (
    id INT PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(100) NOT NULL,
    ativo BOOLEAN DEFAULT TRUE,
    data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabela de lançamentos
CREATE TABLE IF NOT EXISTS lancamentos (
    id INT PRIMARY KEY AUTO_INCREMENT,
    usuario_id INT NOT NULL,
    descricao VARCHAR(255) NOT NULL,
    valor DECIMAL(10,2) NOT NULL,
    entrada DECIMAL(10,2) DEFAULT 0.00,
    saida DECIMAL(10,2) DEFAULT 0.00,
    tipo ENUM('entrada', 'saida') NOT NULL,
    forma_pagamento_id INT NOT NULL,
    data_lancamento DATE NOT NULL,
    data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id),
    FOREIGN KEY (forma_pagamento_id) REFERENCES formas_pagamento(id)
);

-- Tabela de contas a receber
CREATE TABLE IF NOT EXISTS contas_receber (
    id INT PRIMARY KEY AUTO_INCREMENT,
    lancamento_id INT NOT NULL,
    usuario_id INT NOT NULL,
    valor DECIMAL(10,2) NOT NULL,
    data_vencimento DATE NOT NULL,
    data_pagamento DATE NULL,
    status ENUM('PENDENTE', 'PAGO') NOT NULL DEFAULT 'PENDENTE',
    data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (lancamento_id) REFERENCES lancamentos(id),
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id)
);

-- Tabela de logs
CREATE TABLE IF NOT EXISTS logs (
    id INT PRIMARY KEY AUTO_INCREMENT,
    usuario_id INT NOT NULL,
    acao ENUM('criar', 'editar', 'excluir', 'pagar') NOT NULL,
    tabela VARCHAR(50) NOT NULL,
    registro_id INT NOT NULL,
    dados_anteriores TEXT NULL,
    dados_novos TEXT NULL,
    justificativa TEXT NULL,
    ip VARCHAR(45) NULL,
    data_hora TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id)
);

-- Inserir usuário administrador (senha: admin123)
INSERT INTO usuarios (nome, email, senha, admin, ativo) VALUES 
('Administrador', 'admin@livrocaixa.com', '$2y$10$KzhCYRoD/itAKnCuomRl/.AYpAoRVNvxjm3dWDDCAdSzQZGGFohuy', TRUE, TRUE);

-- Inserir formas de pagamento
INSERT INTO formas_pagamento (nome) VALUES 
('Dinheiro'),
('Banco/Cartão/Pix'),
('Vale'),
('Promissória');
