<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Usuário não autenticado']);
    exit();
}

require_once 'config/database.php';
$database = new Database();
$db = $database->getConnection();

try {
    // Validar dados recebidos
    if (!isset($_POST['conta_id']) || !isset($_POST['data_pagamento']) || !isset($_POST['forma_pagamento'])) {
        throw new Exception('Dados incompletos');
    }

    $conta_id = $_POST['conta_id'];
    $data_pagamento = $_POST['data_pagamento'];
    $forma_pagamento_id = $_POST['forma_pagamento'];

    // Iniciar transação
    $db->beginTransaction();

    // Buscar informações da conta a receber
    $query = "SELECT cr.valor as valor_receber, l.descricao 
              FROM contas_receber cr
              JOIN lancamentos l ON cr.lancamento_id = l.id
              WHERE cr.id = :conta_id AND cr.usuario_id = :usuario_id AND cr.status = 'PENDENTE'";
    
    $stmt = $db->prepare($query);
    $stmt->bindValue(':conta_id', $conta_id);
    $stmt->bindValue(':usuario_id', $_SESSION['user_id']);
    $stmt->execute();
    
    $conta = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$conta) {
        throw new Exception('Conta a receber não encontrada ou já foi paga');
    }

    // Debug para verificar o valor
    error_log("Valor a receber: " . $conta['valor_receber']);

    // Inserir lançamento de entrada
    $query = "INSERT INTO lancamentos (usuario_id, tipo, descricao, valor, entrada, saida, data_lancamento, forma_pagamento_id) 
              VALUES (:usuario_id, 'entrada', :descricao, :valor, :entrada, 0, :data_lancamento, :forma_pagamento_id)";
    
    $stmt = $db->prepare($query);
    $stmt->bindValue(':usuario_id', $_SESSION['user_id']);
    $stmt->bindValue(':descricao', "Recebimento: " . $conta['descricao']);
    $stmt->bindValue(':valor', $conta['valor_receber']);
    $stmt->bindValue(':entrada', $conta['valor_receber']); 
    $stmt->bindValue(':data_lancamento', $data_pagamento);
    $stmt->bindValue(':forma_pagamento_id', $forma_pagamento_id);
    $stmt->execute();

    // Atualizar status da conta a receber
    $query = "UPDATE contas_receber 
              SET status = 'PAGO', data_pagamento = :data_pagamento 
              WHERE id = :conta_id";
    
    $stmt = $db->prepare($query);
    $stmt->bindValue(':data_pagamento', $data_pagamento);
    $stmt->bindValue(':conta_id', $conta_id);
    $stmt->execute();

    // Confirmar transação
    $db->commit();

    header('Content-Type: application/json');
    echo json_encode(['success' => true]);

} catch (Exception $e) {
    if ($db->inTransaction()) {
        $db->rollBack();
    }
    
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
