<?php
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?> - Sistema Livro Caixa</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
    <style>
        :root {
            --sidebar-width: 250px;
        }
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: #1e3c72;
            padding-top: 1rem;
            transition: 0.3s;
            z-index: 1000;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.8rem 1rem;
            margin: 0.2rem 1rem;
            border-radius: 5px;
            transition: 0.3s;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .sidebar .nav-link i {
            width: 25px;
        }
        .main-content {
            margin-left: var(--sidebar-width);
            padding: 2rem;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .sidebar.show {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
            }
            .toggle-sidebar {
                display: block !important;
            }
        }
        .toggle-sidebar {
            display: none;
            position: fixed;
            top: 1rem;
            left: 1rem;
            z-index: 1001;
        }
        .card {
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            border: none;
            border-radius: 0.5rem;
        }
    </style>
    <?php if (isset($extra_css)) echo $extra_css; ?>
</head>
<body>
    <button class="btn btn-primary toggle-sidebar">
        <i class="fas fa-bars"></i>
    </button>

    <nav class="sidebar">
        <div class="text-center mb-4">
        <a href="dashboard.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>">
            <i class="fas fa-dollar-sign fa-2x text-white"></i>
            <h4 class="text-white mt-2">Livro Caixa</h4>
        </div>
        <div class="nav flex-column">
            <a href="lancamentos.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'lancamentos.php' ? 'active' : ''; ?>">
                <i class="fas fa-exchange-alt"></i>
                Lançamentos
            </a>
            <a href="contas_receber.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'contas_receber.php' ? 'active' : ''; ?>">
                <i class="fas fa-money-bill-wave"></i>
                Contas a Receber
            </a>
            <a href="formas_pagamento.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'formas_pagamento.php' ? 'active' : ''; ?>">
                <i class="fas fa-credit-card"></i>
                Formas de Pagamento
            </a>
            <?php if ($_SESSION['is_admin']): ?>
            <a href="usuarios.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'usuarios.php' ? 'active' : ''; ?>">
                <i class="fas fa-users"></i>
                Usuários
            </a>
            <a href="logs.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'logs.php' ? 'active' : ''; ?>">
                <i class="fas fa-history"></i>
                Logs
            </a>
            <?php endif; ?>
            <a href="logout.php" class="nav-link mt-auto">
                <i class="fas fa-sign-out-alt"></i>
                Sair
            </a>
        </div>
    </nav>

    <main class="main-content">
        <div class="header d-flex justify-content-between align-items-center">
            <h4 class="mb-0">Bem-vindo, <?php echo htmlspecialchars($_SESSION['user_name']); ?></h4>
            <div class="d-flex align-items-center">
                <span class="me-3"><?php echo $_SESSION['is_admin'] ? 'Administrador' : 'Usuário'; ?></span>
                <a href="logout.php" class="btn btn-outline-danger btn-sm">
                    <i class="fas fa-sign-out-alt"></i> Sair
                </a>
            </div>
        </div>

        <div class="container-fluid">
            <?php if (isset($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
            <?php endif; ?>
            <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>

            <?php echo $content; ?>
        </div>
    </main>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script>
        document.querySelector('.toggle-sidebar').addEventListener('click', function() {
            document.querySelector('.sidebar').classList.toggle('show');
        });

        document.addEventListener('click', function(e) {
            const sidebar = document.querySelector('.sidebar');
            const toggleBtn = document.querySelector('.toggle-sidebar');
            if (window.innerWidth <= 768 && 
                !sidebar.contains(e.target) && 
                !toggleBtn.contains(e.target)) {
                sidebar.classList.remove('show');
            }
        });
    </script>
    <?php if (isset($extra_js)) echo $extra_js; ?>
</body>
</html>
