<div class="row g-2">
    <div class="col-md-3">
        <?php echo Form::text('name', 'Nome')
        ->attrs(['class' => ''])
        ->required(); ?>

    </div>
    <div class="col-md-3">
        <?php echo Form::text('email', 'Email')
        ->attrs(['class' => ''])
        ->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::select('admin', 'Admin', [0 => 'Não', 1 => 'Sim'])
        ->attrs(['class' => 'form-select'])
        ->required(); ?>

    </div>

    <?php if(__isNotificacao(Auth::user()->empresa)): ?>
    <div class="col-md-2">
        <?php echo Form::select('notificacao_cardapio', 'Notificação cardápio', [0 => 'Não', 1 => 'Sim'])
        ->attrs(['class' => 'form-select'])
        ->required(); ?>

    </div>
    <?php endif; ?>

    <?php if(__isNotificacaoMarketPlace(Auth::user()->empresa)): ?>
    <div class="col-md-2">
        <?php echo Form::select('notificacao_marketplace', 'Notificação delivery', [0 => 'Não', 1 => 'Sim'])
        ->attrs(['class' => 'form-select'])
        ->required(); ?>

    </div>
    <?php endif; ?>

    <?php if(__isNotificacaoEcommerce(Auth::user()->empresa)): ?>
    <div class="col-md-2">
        <?php echo Form::select('notificacao_ecommerce', 'Notificação ecommerce', [0 => 'Não', 1 => 'Sim'])
        ->attrs(['class' => 'form-select'])
        ->required(); ?>

    </div>
    <?php endif; ?>
    
    <div class="col-md-2">
        <label class="required">Senha</label>
        <div class="input-group" id="show_hide_password">
            <input required type="password" class="form-control" id="senha" name="password" autocomplete="off" <?php if(isset($senhaCookie)): ?> value="<?php echo e($senhaCookie); ?>" <?php endif; ?>>
            <a class="input-group-text"><i class='ri-eye-line'></i></a>
        </div>
    </div>

    <div class="col-md-3">
        <?php echo Form::select('role_id', 'Controle de acesso', ['' => 'Selecione'] + $roles->pluck('description', 'id')->all())
        ->attrs(['class' => 'select2'])
        ->value(isset($item) && $item->roles ? $item->roles->first()->id : null)
        ->required(); ?>

    </div>

    <?php if(__countLocalAtivo() > 1): ?>
    <div class="col-md-4">
        <label for="">Locais de acesso</label>

        <select required class="select2 form-control select2-multiple" data-toggle="select2" name="locais[]" multiple="multiple">
            <?php $__currentLoopData = __getLocaisAtivos(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php if(in_array($local->id, (isset($item) ? $item->locais->pluck('localizacao_id')->toArray() : []))): ?> selected <?php endif; ?> value="<?php echo e($local->id); ?>"><?php echo e($local->descricao); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <?php else: ?>
    <input type="hidden" value="<?php echo e(__getLocalAtivo() ? __getLocalAtivo()->id : ''); ?>" name="local_id">
    <?php endif; ?>

    <hr>
    <div class="card col-md-3 mt-3 form-input">
        <p>Selecione uma imagem de perfil</p>
        <div class="preview">
            <button type="button" id="btn-remove-imagem" class="btn btn-link-danger btn-sm btn-danger">x</button>
            <?php if(isset($item)): ?>
            <img id="file-ip-1-preview" src="<?php echo e($item->img); ?>">
            <?php else: ?>
            <img id="file-ip-1-preview" src="/imgs/no-image.png">
            <?php endif; ?>
        </div>
        <label for="file-ip-1">Imagem</label>
        <input type="file" id="file-ip-1" name="image" accept="image/*" onchange="showPreview(event);">
    </div>
    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>

<?php $__env->startSection('js'); ?>
<script>
    $(document).ready(function() {
        $("#show_hide_password a").on('click', function(event) {
            event.preventDefault();
            if ($('#show_hide_password input').attr("type") == "text") {
                $('#show_hide_password input').attr('type', 'password');
                $('#show_hide_password i').addClass("bx-hide");
                $('#show_hide_password i').removeClass("bx-show");
            } else if ($('#show_hide_password input').attr("type") == "password") {
                $('#show_hide_password input').attr('type', 'text');
                $('#show_hide_password i').removeClass("bx-hide");
                $('#show_hide_password i').addClass("bx-show");
            }
        });
    });

</script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/apifiscalnet/erp.apifiscal.net.br/resources/views/usuarios/_forms.blade.php ENDPATH**/ ?>