@extends('layouts.header_auth', ['title' => 'Cadastre-se'])

@section('css')
<style type="text/css">
    img{
        display: block;
        margin-left: auto;
        margin-right: auto;
        width: 50%;
    }

    @media screen and (min-width: 800px) {
        .logo-mob{
            margin-top: -40px;
            height: 100px;
        }
    }

    .logo-mob{
        margin-top: -80px;
        height: 170px;
    }

    .auth-fluid .auth-fluid-form-box {
        border: 0 !important;
        border-top: 0 !important;
        box-shadow: none !important;
        background-color: #f6f6f6;
    }

    .card {
        border: 0 !important;
        border-top: 0 !important;
    }
</style>
@endsection

@section('content')
<div class="auth-fluid">
    <!--Auth fluid left content -->
    <div class="auth-fluid-form-box">
        <div class="card-body d-flex flex-column h-100 gap-3">
            <!-- Logo -->
            <div class="auth-brand text-center text-lg-start logo-mob">
                <span><img style="width: 150px; margin-top: 70px;" src="/saas.png" alt="dark logo"></span>
            </div>

            <div class="my-auto">
                <!-- title-->
                <h4 class="mt-0">Cadastre-se</h4>
                <p class="text-muted mb-4">Crie sua conta, leva menos de um minuto!</p>

                <!-- form -->
                <form method="POST" action="{{ route('register') }}">
                    @csrf
                    <div class="mb-3">
                        <label for="name" class="form-label">Nome</label>
                        <input class="form-control @error('name') is-invalid @enderror" type="text" id="name" 
                               placeholder="Digite seu nome" required name="name" value="{{ old('name') }}">
                        @error('name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input class="form-control @error('email') is-invalid @enderror" type="email" id="email" 
                               placeholder="Digite seu email" required name="email" value="{{ old('email') }}">
                        @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="password" class="form-label">Senha</label>
                        <input class="form-control @error('password') is-invalid @enderror" type="password" 
                               id="password" placeholder="Digite sua senha" required name="password">
                        @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">Confirmar Senha</label>
                        <input class="form-control" type="password" id="password_confirmation" 
                               placeholder="Confirme sua senha" required name="password_confirmation">
                    </div>

                    <div class="d-grid mb-0 text-center">
                        <button class="btn btn-primary" type="submit">
                            <i class="ri-user-add-line"></i> Cadastrar
                        </button>
                    </div>
                </form>
                <!-- end form-->
            </div>

            <!-- Footer-->
            <footer class="footer footer-alt">
                <p class="text-muted">Já tem conta? <a href="{{ route('login') }}" class="text-muted ms-1"><b>Login</b></a></p>
            </footer>

        </div> <!-- end .card-body -->
    </div>
    <!-- end auth-fluid-form-box-->
</div>
@endsection
