<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">
	<div class="card-body">

		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__bounce" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<h4>Total de Arquivos importados: <strong class="text-info">
				<?php echo e(sizeof($data)); ?>

			</strong></h4>

			<form method="post" action="/vendas/importStore">
				<?php echo csrf_field(); ?>
				<div class="row">
					<div class="col-lg-12 col-xl-12">
						<div class="form-group col-lg-3 col-md-4 col-sm-6">
							<label class="col-form-label">Local</label>
							<div class="">
								<div class="input-group date">
									<select class="custom-select form-control" name="tabela">
										<option value="vendas">VENDAS</option>
										<option <?php if(!$data[0]['cliente']): ?> selected <?php endif; ?> value="venda_caixas">PDV</option>
									</select>
								</div>
							</div>
						</div>
					</div>
				</div>

				<input type="hidden" value="<?php echo e(json_encode($data)); ?>" name="data">

				<div class="col-lg-12 col-xl-12">
					<div class="accordion accordion-toggle-arrow" id="accordionExample1">

						<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="card">
							<div class="card-header">
								<div class="card-title collapsed" data-toggle="collapse" data-target="#collapseOne<?php echo e($key); ?>">
									<label class="checkbox checkbox-info check-sub">
										<input checked type="checkbox" name="ch_<?php echo e($d['chave']); ?>">
										<span></span>
									</label>
									<strong style="margin-left: 5px;" class="text-info"><?php echo e($d['chave']); ?></strong> 
									<strong style="margin-left: 5px;" class="text-danger"><?php echo e(\Carbon\Carbon::parse($d['data'])->format('d/m/Y H:i:s')); ?></strong>
									<i style="margin-left: 5px;" class="la la-angle-double-down"></i>
								</div>
							</div>
							<div id="collapseOne<?php echo e($key); ?>" class="collapse" data-parent="#accordionExample1">
								<div class="card-body">
									<?php if($d['cliente']): ?>
									<div class="card card-custom gutter-b">
										<div class="card-body">
											<h3 class="card-title">Cliente</h3>

											<h5>Razão social: <strong><?php echo e($d['cliente']['razao_social']); ?></strong></h5>
											<h5>Nome fantasia: <strong><?php echo e($d['cliente']['nome_fantasia']); ?></strong></h5>
											<h5>CNPJ/CPF: <strong><?php echo e($d['cliente']['cpf_cnpj']); ?></strong></h5>
											<h5>IE/RG: <strong><?php echo e($d['cliente']['ie_rg']); ?></strong></h5>
											<h5>Endereço: <strong><?php echo e($d['cliente']['rua']); ?>, <?php echo e($d['cliente']['numero']); ?> - <?php echo e($d['cliente']['bairro']); ?></strong></h5>
										</div>
									</div>
									<?php endif; ?>

									<div class="card card-custom gutter-b">
										<div class="card-body">
											<h3 class="card-title">Produtos</h3>

											<?php $__currentLoopData = $d['produtos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<h5>Código: <strong><?php echo e($p['codigo']); ?></strong></h5>
											<h5>Nome: <strong><?php echo e($p['xProd']); ?></strong></h5>
											<h5>CFOP: <strong><?php echo e($p['CFOP']); ?></strong></h5>
											<h5>Unidade: <strong><?php echo e($p['uCom']); ?></strong></h5>
											<h5>Valor unitário: <strong><?php echo e(number_format((float)$p['vUnCom'], 2, ',', '.')); ?></strong></h5>
											<h5>Quantidade: <strong><?php echo e($p['qCom']); ?></strong></h5>
											<h5>NCM: <strong><?php echo e($p['NCM']); ?></strong></h5>
											<h5>Código de barras: <strong><?php echo e($p['codBarras']); ?></strong></h5>

											<hr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</div>
									</div>

									<div class="card card-custom gutter-b">
										<div class="card-body">
											<h3 class="card-title">Fatura</h3>

											<?php $__currentLoopData = $d['fatura']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<h5>Vencimento: <strong><?php echo e(\Carbon\Carbon::parse($f['vencimento'])->format('d/m/Y')); ?></strong></h5>
											<h5>Valor: <strong><?php echo e(number_format((float)$f['valor_parcela'], 2, ',', '.')); ?></strong></h5>
											<hr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</div>
									</div>

								</div>
							</div>
						</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

					</div>
				</div><br>
				<div class="row">
					<div class="col-xl-12">

						<div class="col-lg-3">
							<button style="width: 100%;" id="salvar-venda" type="submit" class="btn btn-lg btn-success">
								<i class="la la-check"></i>
								Salvar Importação
							</button>
						</div>
					</div>
				</div>
			</form>

		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>	
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/vendas/import.blade.php ENDPATH**/ ?>