<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__bounce">
	<div class="card-body">
		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<h3>Agendamento <strong><?php echo e($agendamento->id); ?></strong></h3>
			<h3>Cliente: <strong class="text-info"><?php echo e($agendamento->cliente->razao_social); ?> - <?php echo e($agendamento->cliente->telefone); ?></strong></h3>

			<h3>Atendente: <strong class="text-info"><?php echo e($agendamento->funcionario->nome); ?></strong></h3>
			<h3>Total: <strong class="text-info"><?php echo e($agendamento->total); ?></strong></h3>
			<?php if($agendamento->desconto > 0): ?>
			<h3>Desconto: <strong class="text-danger"><?php echo e($agendamento->desconto); ?></strong></h3>
			<?php endif; ?>
			<?php if($agendamento->acrescimo > 0): ?>
			<h3>Acrescimo: <strong class="text-danger"><?php echo e($agendamento->acrescimo); ?></strong></h3>
			<?php endif; ?>

			<?php if($agendamento->observacao != ''): ?>
			<h3>Observação: <strong class="text-danger"><?php echo e($agendamento->observacao); ?></strong></h3>
			<?php endif; ?>

			<div class="row">
				<div class="col-sm-6 col-lg-6 col-12">
					<div class="card card-custom gutter-b">
						<div class="card-body">
							<h4>Data: <strong class="text-primary"><?php echo e(\Carbon\Carbon::parse($agendamento->data)->format('d/m/Y')); ?></strong></h4>
							<h4>Início: <strong class="text-success"><?php echo e($agendamento->inicio); ?> </strong></h4>
							<h4>Término: <strong class="text-danger"><?php echo e($agendamento->termino); ?> </strong></h4>
						</div>
					</div>
				</div>
				<div class="col-sm-6 col-lg-6 col-12">
					<div class="card card-custom gutter-b">
						<div class="card-body">
							<h4>Serviços: </h4>

							<?php $__currentLoopData = $agendamento->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<p><?php echo e($s->servico->nome); ?> x R$ <?php echo e($s->servico->valor); ?></p>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</div>
					</div>
				</div>
			</div>

			<div class="row">
				<a class="btn btn-danger" onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/agendamentos/delete/<?php echo e($agendamento->id); ?>" }else{return false} })' href="#!">
					Remover agendamento			
				</a>

				<a style="margin-left: 10px;" class="btn btn-success" onclick='swal("Atenção!", "Deseja ir para frente de caixa?", "warning").then((sim) => {if(sim){ location.href="/agendamentos/irParaFrenteCaixa/<?php echo e($agendamento->id); ?>" }else{return false} })' href="#!">
					Ir Para frente de caixa			
				</a>

				<a style="margin-left: 10px;" class="btn btn-warning" onclick='swal("Atenção!", "Deseja alterar para finalizado?", "warning").then((sim) => {if(sim){ location.href="/agendamentos/alterarStatus/<?php echo e($agendamento->id); ?>" }else{return false} })' href="#!">
					Alterar para finalizado		
				</a>
			</div>

		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>	
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/agendamentos/detalhes.blade.php ENDPATH**/ ?>