<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">
	<div class="card-body">

		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>">
			<form method="get" action="/pedidos/filtroComanda">
				<div class="row align-items-center">

					<div class="form-group col-lg-3 col-md-4 col-sm-6">
						<label class="col-form-label">Comanda</label>
						<div class="">
							<div class="input-group">
								<input type="text" name="numero_comanda" class="form-control" value="<?php echo e(isset($comanda) ? $comanda : ''); ?>" />
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data Inicial</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_inicial" class="form-control" readonly value="<?php echo e(isset($comanda) ? $comanda : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data Final</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_final" class="form-control" readonly value="<?php echo e(isset($dataFinal) ? $dataFinal : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button style="margin-top: 15px;" class="btn btn-light-primary px-6 font-weight-bold">Pesquisa</button>
					</div>
				</div>
			</form>
			<br>
			<h4>Controle de Comandas</h4>
			<label>Numero de registros: <?php echo e(count($comandas)); ?></label>	
			<p class="text-danger"><?php echo e($mensagem); ?></p>				
			<p class="text-danger">*Comanda em vermelho contém produtos deletados</p>		

			<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
				<div class="row">
					<div class="col-xl-12">

						<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

							<table class="datatable-table" style="max-width: 100%; overflow: scroll">
								<thead class="datatable-head">
									<tr class="datatable-row" style="left: 0px;">
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 70px;">#</span></th>
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Comanda</span></th>
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Observação</span></th>
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor</span></th>
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Data de Criação</span></th>
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Data de Finalização</span></th>
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Ações</span></th>
									</tr>
								</thead>
								<tbody id="body" class="datatable-body">
									<?php $__currentLoopData = $comandas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr class="datatable-row <?php if($v->temItemDeletetado()): ?> bg-danger <?php endif; ?>">
										<td class="datatable-cell">
											<span class="codigo" style="width: 70px;">
												<?php echo e($v->id); ?>

											</span>
										</td>
										<td class="datatable-cell">
											<span class="codigo" style="width: 100px;">
												<?php echo e($v->comanda); ?>

											</span>
										</td>
										<td class="datatable-cell">
											<span class="codigo" style="width: 100px;">
												<a href="#!" onclick='swal("", "<?php echo e($v->observacao); ?>", "info")' class="btn btn-light-info <?php if(!$v->observacao): ?> disabled <?php endif; ?>">
													Ver
												</a>
											</span>
										</td>

										<td class="datatable-cell">
											<span class="codigo" style="width: 100px;">
												<?php echo e(number_format($v->somaItems(), 2)); ?>

											</span>
										</td>

										<td class="datatable-cell">
											<span class="codigo" style="width: 100px;">
												<?php echo e(\Carbon\Carbon::parse($v->created_at)->format('d/m/Y H:i:s')); ?>

											</span>
										</td>
										<td class="datatable-cell">
											<span class="codigo" style="width: 100px;">
												<?php echo e(\Carbon\Carbon::parse($v->updated_at)->format('d/m/Y H:i:s')); ?>

											</span>
										</td>

										<td class="datatable-cell">
											<span class="codigo" style="width: 100px;">
												<a target="_blank" href="/pedidos/verDetalhes/<?php echo e($v->id); ?>" class="btn btn-sm btn-info">
													<i class="la la-list"></i>
												</a>
											</span>
										</td>

										
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>


<?php $__env->stopSection(); ?>	
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nextsistemas/nextweb.nextsistemas.app.br/resources/views/pedido/controle_comandas.blade.php ENDPATH**/ ?>