<?php $__env->startSection('content'); ?>
<div class="card card-custom gutter-b">
	<div class="card-body">

		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>">
			<form class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft" method="get" action="/rep/filtro">
				<div class="row align-items-center">

					<div class="form-group col-lg-3 col-md-3 col-sm-3">
						<label class="col-form-label">Estado</label>
						<div class="">
							<select name="status" class="custom-select">
								<option <?php if(isset($status)): ?> <?php if($status == 'TODOS'): ?> selected <?php endif; ?> <?php endif; ?> value="TODOS">TODOS</option>
								<option <?php if(isset($status)): ?> <?php if($status == 1): ?> selected <?php endif; ?> <?php endif; ?> value="1">ATIVO</option>
								<option <?php if(isset($status)): ?> <?php if($status == 0): ?> selected <?php endif; ?> <?php endif; ?> value="0">DESATIVADO</option>
							</select>
						</div>
					</div>
					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button style="margin-top: 15px;" class="btn btn-light-primary px-6 font-weight-bold">Pesquisa</button>
					</div>
				</div>
			</form>

			<h4 class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">Lista de empresas</h4>

			<label class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">Registros: <strong class="text-success"><?php echo e(sizeof($empresas)); ?></strong></label>
			<div class="col-xl-12 <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
				<div class="row">
					<a href="/rep/novaEmpresa" class="btn btn-success">
						<i class="la la-plus"></i>
						Nova Empresa
					</a>

				</div>
			</div>

			<div class="col-xl-12 <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">

				<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

					<table class="datatable-table" style="max-width: 100%; overflow: scroll">
						<thead class="datatable-head">
							<tr class="datatable-row" style="left: 0px;">
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 70px;">#</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Nome</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Data cadastro</span></th>
								
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 250px;">Endereço</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Cidade</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Status</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 300px;">Ações</span></th>
							</tr>
						</thead>

						<tbody class="datatable-body">
							<?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

							<tr class="datatable-row">
								<td class="datatable-cell">
									<span class="codigo" style="width: 70px;">
										<?php echo e($e->empresa->id); ?>

									</span>
								</td>
								<td class="datatable-cell">
									<span class="codigo" style="width: 150px;">
										<?php echo e($e->empresa->nome); ?>

									</span>
								</td>
								<td class="datatable-cell">
									<span class="codigo" style="width: 120px;">
										<?php echo e(\Carbon\Carbon::parse($e->empresa->created_at)->format('d/m/Y H:i')); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 250px;">
										<?php echo e($e->empresa->rua); ?>, <?php echo e($e->empresa->numero); ?> - <?php echo e($e->empresa->bairro); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php echo e($e->empresa->cidade); ?>

									</span>
								</td>


								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php if($e->empresa->status): ?>
										<span class="label label-xl label-inline label-light-success">
											ATIVO
										</span>

										<?php else: ?>
										<span class="label label-xl label-inline label-light-danger">
											DESATIVADO
										</span>
										<?php endif; ?>
									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 300px;">
										<a href="/rep/detalhes/<?php echo e($e->empresa_id); ?>" class="btn btn-sm btn-primary">
											Detalhes
										</a>

										<a href="/rep/financeiro/<?php echo e($e->empresa_id); ?>" class="btn btn-sm btn-info">
											Financeiro
										</a>


									</span>
								</td>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>	

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/rep/empresas.blade.php ENDPATH**/ ?>