<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">
	<div class="col-xl-12">
		
		<div class="card-body">
			<div class="row">
				
				<div class="col-sm-12 col-lg-12 col-md-6 col-xl-6">

					<h4>Código: <strong><?php echo e($compra->id); ?></strong></h4>
					<h4>Nº NF-e Importada: <strong><?php echo e($compra->nf > 0 ? $compra->nf : '*'); ?></strong></h4>
					<h4>Nº NF-e Emitida: <strong><?php echo e($compra->numero_emissao > 0 ? $compra->numero_emissao : '*'); ?></strong></h4>


					<h5>Usuário: <strong><?php echo e($compra->usuario->nome); ?></strong></h5>
					
				</div>

				<div class="col-sm-12 col-lg-12 col-md-6 col-xl-6">

					<h5>Fornecedor: <strong><?php echo e($compra->fornecedor->razao_social); ?></strong></h5>
					<h5>Data: <strong><?php echo e(\Carbon\Carbon::parse($compra->created_at)->format('d/m/Y H:i:s')); ?></strong></h5>

					<?php if($compra->numero_emissao > 0): ?>
					<h5>Data de Emissão: <strong><?php echo e(\Carbon\Carbon::parse($compra->updated_at)->format('d/m/Y H:i:s')); ?></strong></h5>
					<h5>Chave: <strong>
						<?php echo e($compra->chave ?? '--'); ?>

					</strong></h5>

					<?php endif; ?>

					<h5>Estado: 
						<?php if($compra->estado == 'NOVO'): ?>
						<span class="label label-xl label-inline label-light-primary">Disponível</span>

						<?php elseif($compra->estado == 'APROVADO'): ?>
						<span class="label label-xl label-inline label-light-success">Aprovado</span>
						<?php elseif($compra->estado == 'CANCELADO'): ?>
						<span class="label label-xl label-inline label-light-danger">Cancelado</span>
						<?php else: ?>
						<span class="label label-xl label-inline label-light-warning">Rejeitado</span>
						<?php endif; ?>
					</h5>
				</div>
			</div>
		</div>
	</div>

	<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>">


	<div class="card-body">

		<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
			<div class="card card-custom gutter-b example example-compact">
				<div class="card-header">

					<div class="col-xl-12">
						<div class="row">

							<div class="col-xl-12">

								<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">
									<br>
									<h4>Itens da Compra</h4>

									<table class="datatable-table" style="max-width: 100%; overflow: scroll">
										<thead class="datatable-head">
											<tr class="datatable-row" style="left: 0px;">
												<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">#</span></th>
												<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Produto</span></th>
												<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor</span></th>
												<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">Quantidade</span></th>

												<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">Subtotal</span></th>

											</tr>
										</thead>
										<tbody class="datatable-body">
											<?php 
											$p = null;
											?>
											<?php $__currentLoopData = $compra->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php 
											$p = $i;
											?>
											<tr class="datatable-row" style="left: 0px;">
												<td class="datatable-cell"><span class="codigo" style="width: 80px;"><?php echo e($i->produto_id); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 150px;"><?php echo e($i->produto->nome); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(number_format($i->valor_unitario, 2, ',', '.')); ?></span></td>

												<td class="datatable-cell"><span class="codigo" style="width: 80px;"><?php echo e($i->quantidade); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 80px;"><?php echo e(number_format(($i->valor_unitario * $i->quantidade), 2, ',', '.')); ?></span></td>


											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>

						</div>

					</div>
				</div>

				<div class="card-body">
					<div class="row">
						<div class="col-sm-12 col-lg-12 col-md-12 col-xl-6">
							<div class="card card-custom gutter-b example example-compact">
								<div class="card-header">

									<div class="card-body">
										<h4>Fatura</h4>
										<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">
											<table class="datatable-table" style="max-width: 100%; overflow: scroll">
												<thead class="datatable-head">
													<tr class="datatable-row" style="left: 0px;">
														<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Vencimento</span></th>
														<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor</span></th>

													</tr>
												</thead>


												<?php if(sizeof($compra->fatura) > 0): ?>
												<tbody class="datatable-body">
													<?php $__currentLoopData = $compra->fatura; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr class="datatable-row" style="left: 0px;">
														<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(\Carbon\Carbon::parse($f->data_vencimento)->format('d/m/Y')); ?>

														</span></td>
														<td class="datatable-cell"><span class="codigo" style="width: 100px;">
															<?php echo e(number_format(($f->valor_integral), 2, ',', '.')); ?>

														</span></td>

													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</tbody>
												<?php else: ?>
												<tbody class="datatable-body">
													<tr class="datatable-row" style="left: 0px;">
														<td class="datatable-cell"><span class="codigo" style="width: 80px;">
															<?php echo e(\Carbon\Carbon::parse($compra->created_at)->format('d/m/Y')); ?>

														</span></td>
														<td class="datatable-cell"><span class="codigo" style="width: 80px;">
															<?php echo e(number_format(($compra->valor), 2, ',', '.')); ?>

														</span></td>

													</tr>
												</tbody>
												<?php endif; ?>


											</table>
										</div>



									</div>



								</div>
							</div>
						</div>

						<div class="col-sm-12 col-lg-12 col-md-12 col-xl-6">
							<div class="card card-custom gutter-b example example-compact">
								<div class="card-header">

									<div class="card-body">

										<div class="form-group validated">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Natureza de Operação</label>

											<select class="custom-select form-control" id="natureza" name="natureza">
												<?php $__currentLoopData = $naturezas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($n->id); ?>"><?php echo e($n->natureza); ?> - <?php echo e($n->CFOP_entrada_estadual); ?>/<?php echo e($n->CFOP_entrada_inter_estadual); ?></option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>

										</div>

										<div class="form-group validated">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Tipo de Pagamento</label>

											<select class="custom-select form-control" id="tipo_pagamento" name="tipo_pagamento">
												<?php $__currentLoopData = $tiposPagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

												<option value="<?php echo e($key); ?>"><?php echo e($key); ?> - <?php echo e($t); ?></option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>

										</div>
									</div>
								</div>
							</div>
						</div>


						<div class="col-12">

							<div class="card card-custom gutter-b example example-compact">

								<div class="card-body">
									<?php if($compra->estado == 'NOVO'): ?>
									<div class="row">
										<div class="col-12">
											<button data-toggle="modal" data-target="#modal-referencia-nfe" <?php if(sizeof($compra->chaves) == 0): ?> class="btn btn-light" <?php else: ?> class="btn btn-info" <?php endif; ?>>
												<i class="la la-list"></i>
												Referênciar NF-e
											</button>
										</div>
									</div>
									<?php endif; ?>
									<br>
									<h3 class="card-title">Total: R$ <strong class="red-text"><?php echo e(number_format($compra->valor, 2, ',', '.')); ?></strong></h3>


									<h5>Oservação: 
										<strong>
											<?php echo e($compra->observacao); ?>


											<?php
											$veiCpl = '';


											if($p->produto->renavam != ''){
											$veiCpl = 'RENAVAM ' . $p->produto->renavam;
											if($p->produto->placa != '') $veiCpl .= ', PLACA ' . $p->produto->placa;
											if($p->produto->chassi != '') $veiCpl .= ', CHASSI ' . $p->produto->chassi;
											if($p->produto->combustivel != '') $veiCpl .= ', COMBUSTÍVEL ' . $p->produto->combustivel;
											if($p->produto->ano_modelo != '') $veiCpl .= ', ANO/MODELO ' . $p->produto->ano_modelo;
											if($p->produto->cor_veiculo != '') $veiCpl .= ', COR ' . $p->produto->cor_veiculo;

										}
										?>

										<?php echo e($veiCpl); ?>

									</strong>
								</h5>

								<?php if($compra->chave != ''): ?>

								<?php if($compra->estado != 'CANCELADO'): ?>


								<a target="_blank" class="btn btn-light-success" href="/compras/imprimir/<?php echo e($compra->id); ?>">
									Imprimir
								</a>

								<a target="_blank" class="btn btn-light-dark" href="/compras/downloadXml/<?php echo e($compra->id); ?>">
									Downlaod XML
								</a>

								<a href="#!" class="btn btn-light-danger" data-toggle="modal" data-target="#modal-cancelar">
									Cancelar
								</a>

								<a id="btn-consulta" href="#!" class="spinner-white spinner-right btn btn-light-info">
									Consultar
								</a>

								<a data-toggle="modal" data-target="#modal4" class="btn btn-light-warning">
									Carta de correção
								</a>

								<?php else: ?>

								<a target="_blank"  class="btn btn-light-danger" href="/compras/downloadXmlCancela/<?php echo e($compra->id); ?>">
									Downlaod XML Cancelamento
								</a>

								<a id="btn-consulta" href="#!" class="spinner-white spinner-right btn btn-light-info">
									Consultar
								</a>

								<?php endif; ?>

								<?php else: ?>


								<a onclick="xmlTemporaria(<?php echo e($compra->id); ?>)" type="button" class="btn btn-warning">
									Xml Temporário
								</a>

								<a onclick="danfeTemporaria(<?php echo e($compra->id); ?>)" type="button" class="btn btn-info">
									Danfe Temporária
								</a>

								<a onclick="enviar(<?php echo e($compra->id); ?>)" type="button" id="btn-enviar-nfe" class="btn btn-success spinner-white spinner-right">
									Transmitir para Sefaz
								</a>

								<?php endif; ?>

							</div>
						</div>
					</div>

				</div>
			</div>

		</div>
	</div>
</div>



</div>

<div class="modal fade" id="modal-cancelar" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Cancelar NF-e de Entrada</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">

				<div class="row">
					<div class="form-group validated col-sm-12 col-lg-12">
						<label class="col-form-label">Justificativa</label>
						<div class="">
							<input id="justificativa" placeholder="Informe no minimo 15 caracteres" type="text" class="form-control" name="justificativa" value="">
						</div>
					</div>
				</div>

				<input type="hidden" value="<?php echo e($compra->id); ?>" id="compra_id" name="">

			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-light-warning font-weight-bold" data-dismiss="modal">Fechar</button>
				<button type="button" id="btn-cancelar" onclick="cancelar()" class="btn btn-danger font-weight-bold spinner-white spinner-right">Cancelar</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal4" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">CARTA DE CORREÇÃO NF-e ENTRADA<strong class="text-danger" style="margin-left: 3px;"><?php echo e($compra->numero_emissao); ?></strong></h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group validated col-sm-12 col-lg-12">
						<label class="col-form-label" id="">Correção</label>
						<div class="">
							<input type="text" id="correcao" placeholder="Correção minimo de 15 caracteres" name="correcao" class="form-control" value="">
						</div>
					</div>
				</div>

			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
				<button type="button" id="btn-corrigir-2" onclick="cartaCorrecao()" class="btn btn-light-success font-weight-bold spinner-white spinner-right">Corrigir NFe</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-referencia-nfe" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Referência NF-e</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">
				<form class="row" method="post" action="/compras/salvarChaveRef">
					<?php echo csrf_field(); ?>
					<input type="hidden" value="<?php echo e($compra->id); ?>" name="compra_id">
					<div class="form-group validated col-12 col-lg-10">
						<div class="">
							<input required="" minlength="44" name="chave" placeholder="Chave" type="text" id="chave" class="form-control">
						</div>
					</div>

					<div class="form-group validated col-12 col-lg-2">
						<button type="submit" class="btn btn-success">
							<i class="la la-plus"></i>
						</button>
					</div>
				</form>

				<div class="row">
					<div class="col-12">

						<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">
							<table class="datatable-table" id="chaves">
								<thead class="datatable-head">
									<tr class="datatable-row">
										<th class="datatable-cell datatable-cell-sort">
											Chaves adcionadas
										</th>
									</tr>
								</thead>
								<tbody class="datatable-body" id="chaves">
									<?php $__currentLoopData = $compra->chaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr style="margin-top: 10px;">
										<td style="font-weight: bold; font-size: 17px; margin-right: 20px;"><?php echo e($ch->chave); ?></td>
										<td>
											<a style="margin-left: 20px;" href="/compras/deleteChave/<?php echo e($ch->id); ?>" class="btn btn-small btn-danger">
												<i class="la la-trash"></i>
											</a>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/compraManual/emitirEntrada.blade.php ENDPATH**/ ?>