<?php $__env->startSection('content'); ?>
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<div class="container">
		<div class="card card-custom gutter-b example example-compact">
			<div class="col-lg-12">
				<form method="post" action="<?php echo e(isset($conta) ? '/contasReceber/update': '/contasReceber/save'); ?>" enctype="multipart/form-data">
					<input type="hidden" name="id" value="<?php echo e(isset($conta) ? $conta->id : 0); ?>">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">

							<h3 class="card-title"><?php echo e(isset($conta) ? "Editar": "Cadastrar"); ?> Conta a Receber</h3>
						</div>
					</div>
					<?php echo csrf_field(); ?>
					<div class="row">
						<div class="col-xl-12">
							<div class="kt-section kt-section--first">
								<div class="kt-section__body">

									<div class="row">
										<div class="form-group validated col-sm-6 col-lg-4">
											<label class="col-form-label">Referencia</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('referencia')): ?> is-invalid <?php endif; ?>" name="referencia" value="<?php echo e(isset($conta) ? $conta->referencia : old('referencia')); ?>">
												<?php if($errors->has('referencia')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('referencia')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<?php if(!isset($conta) || $conta->venda_id == null): ?>
										<div class="form-group validated col-sm-9 col-lg-6 col-12">
											<label class="col-form-label" id="">Cliente</label><br>
											<select class="form-control select2" style="width: 100%" id="kt_select2_3" name="cliente_id">
												<option value="">Selecione o cliente</option>
												<?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option
												<?php if(isset($conta)): ?>
												<?php if($conta->cliente_id != null): ?>
												<?php if($conta->cliente_id == $c->id): ?>
												selected
												<?php endif; ?>
												<?php endif; ?>
												<?php endif; ?>
												value="<?php echo e($c->id); ?>"><?php echo e($c->id); ?> - <?php echo e($c->razao_social); ?> (<?php echo e($c->cpf_cnpj); ?>)</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
										</div>
										<?php endif; ?>

										<div class="form-group validated col-lg-3 col-md-4 col-sm-6">
											<label class="col-form-label">Categoria</label>

											<select class="custom-select form-control <?php if($errors->has('categoria_id')): ?> is-invalid <?php endif; ?>" id="categoria_id" name="categoria_id">
												<?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($cat->id); ?>" <?php if(isset($conta)): ?>
													<?php if($cat->id == $conta->categoria_id): ?>
													selected
													<?php endif; ?>
													<?php endif; ?> ><?php echo e($cat->nome); ?>

												</option>

												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

											</select>
											<?php if($errors->has('categoria_id')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('categoria_id')); ?>

											</div>
											<?php endif; ?>

										</div>

										<div class="form-group col-lg-3 col-md-9 col-sm-12">
											<label class="col-form-label">Data de vencimento</label>
											<div class="">
												<div class="input-group date">
													<input type="text" name="vencimento" class="form-control <?php if($errors->has('vencimento')): ?> is-invalid <?php endif; ?>" readonly value="<?php echo e(isset($conta) ? \Carbon\Carbon::parse($conta->data_vencimento)->format('d/m/Y') : old('vencimento')); ?>" id="kt_datepicker_3" />
													<div class="input-group-append">
														<span class="input-group-text">
															<i class="la la-calendar"></i>
														</span>
													</div>
												</div>
												<?php if($errors->has('vencimento')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('vencimento')); ?>

												</div>
												<?php endif; ?>

											</div>
										</div>

										<div class="form-group validated col-lg-2 col-md-4 col-sm-6">
											<label class="col-form-label">Valor</label>

											<input type="text" class="form-control <?php if($errors->has('valor')): ?> is-invalid <?php endif; ?> money" name="valor" value="<?php echo e(isset($conta) ? number_format($conta->valor_integral, $casasDecimais, ',', '.') : old('valor')); ?>">
											<?php if($errors->has('valor')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('valor')); ?>

											</div>
											<?php endif; ?>

										</div>

										<?php if(!isset($conta)): ?>
										<div class="form-group col-lg-2 col-md-9 col-sm-12">
											<label class="col-form-label">Conta Recebida</label>
											
											<div class="col-lg-12 col-xl-12">
												<span class="switch switch-outline switch-success">
													<label>
														<input <?php if(isset($conta) && $conta->status): ?> checked 
														<?php endif; ?> type="checkbox" id="pago" name="status" type="checkbox" id="status">
														<span></span>
													</label>
												</span>

											</div>

										</div>
										<?php endif; ?>
									</div>

									<?php if(!isset($conta)): ?>
									<div class="row">

										

										<div class="form-group validated col-lg-4 col-md-4 col-sm-6">
											<label class="col-form-label">Salvar até este mês (opcional) </label>

											<input placeholder="mm/aa" type="text" class="form-control <?php if($errors->has('recorrencia')): ?> is-invalid <?php endif; ?>" id="recorrencia" name="recorrencia" >
											<?php if($errors->has('recorrencia')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('recorrencia')); ?>

											</div>
											<?php endif; ?>
											<p style="color: red; margin-top: 5px;"> *Este campo deve ser preenchido se ouver recorrência para este registro
											</p>
										</div>
										


									</div>

									<?php endif; ?>
								</div>

							</div>
						</div>
					</div>
				</div>
				<div class="card-footer">

					<div class="row">
						<div class="col-xl-2">

						</div>
						<div class="col-lg-3 col-sm-6 col-md-4">
							<a style="width: 100%" class="btn btn-danger" href="/contasReceber">
								<i class="la la-close"></i>
								<span class="">Cancelar</span>
							</a>
						</div>
						<div class="col-lg-3 col-sm-6 col-md-4">
							<button style="width: 100%" type="submit" class="btn btn-success">
								<i class="la la-check"></i>
								<span class="">Salvar</span>
							</button>
						</div>

					</div>
				</div>
			</form>
		</div>
	</div>
</div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/contaReceber/register.blade.php ENDPATH**/ ?>