<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relatório de Lista de Preços</h3>
		<?php if($data): ?>
		<h4>Data: <?php echo e($data); ?></h4>
		<?php endif; ?>

		<h4>Lista de Preço <strong class="text-primary"><?php echo e($lista->nome); ?></strong></h4>
		<h4>Percentual de alteração: <strong class="text-danger"><?php echo e($lista->percentual_alteracao); ?>%</strong> sobre o
			<?php if($lista->tipo == 1): ?>
			valor de compra
			<?php else: ?>
			valor de venda
			<?php endif; ?>
		</h4>
	</div>

	<table class="pure-table">
		<thead>
			<tr>
				<!-- <th width="50">ID</th> -->
				<th width="170">PRODUTO</th>
				<th width="80">VALOR VENDA PADRÃO</th>
				<th width="80">VALOR DE COMPRA</th>
				<th width="80">VALOR DE VENDA LISTA</th>
				<th width="80">% LUCRO</th>
			</tr>
		</thead>

		<tbody>
			<?php $__currentLoopData = $lista->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr class="datatable-row">
				<td>
					<?php echo e($i->produto->nome); ?>

				</td>
				<td><?php echo e(number_format($i->produto->valor_venda, 2, ',', '.')); ?>

				</td>
				<td><?php echo e(number_format($i->produto->valor_compra, 2, ',', '.')); ?>

				</td>
				<td><?php echo e(number_format($i->valor, 2, ',', '.')); ?>

				</td>
				<td><?php echo e(number_format($i->percentual_lucro, 2, ',', '.')); ?>

				</td>
				
			</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

		</tbody>

	</table>
	<h4>TOTAL DE ITENS: <strong class="text-danger"><?php echo e(sizeof($lista->itens)); ?></strong></h4>
	
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('relatorios.cabecalho', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/relatorios/lista_preco.blade.php ENDPATH**/ ?>