<!DOCTYPE html>
<html>
<head>
	<title></title>
	<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.1/build/pure-min.css" integrity="sha384-oAOxQR6DkCoMliIh8yFnu25d7Eq/PHS21PClpwjOTeU2jRSq11vu66rf90/cZr47" crossorigin="anonymous">
</head>
<body>

	<div class="row">
		<div class="col s12">
			<h3 class="center-align">Relátorio de Fluxo de Caixa</h3>
		</div>



		<table class="pure-table">
			<thead style="background: #999;">
				<tr>
					<th>DATA</th>
					<th width="200px;">VENDAS</th>
					<th width="100px;">CONTAS A RECEBER</th>
					<th>CONTA CRÉDITO</th>
					<th>CONTA A PAGAR</th>
					<th>RESULTADO</th>
				</tr>
			</thead>

			<?php  
			$totalVenda = 0;
			$totalContaReceber = 0;
			$totalContaPagar = 0;
			$totalCredito = 0;
			$totalResultado = 0; 
			?>

			<tbody>
				<?php $__currentLoopData = $fluxo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<tr class="<?php if($key%2 == 0): ?> pure-table-odd <?php endif; ?>">
					<td><?php echo e($f['data']); ?></td>
					<td width="120px;"><label>Vendas: R$ <?php echo e(number_format($f['venda'], 2, ',', '.')); ?></label><br>
						<label>Frente de caixa: R$ <?php echo e(number_format($f['venda_caixa'], 2, ',', '.')); ?></label>
						<h5>Total R$ <?php echo e(number_format($f['venda']+$f['venda_caixa'], 2, ',', '.')); ?></h5>
					</td>
					<td>R$ <?php echo e(number_format($f['conta_receber'], 2, ',', '.')); ?></td>
					<td>R$ <?php echo e(number_format($f['credito_venda'], 2, ',', '.')); ?></td>
					<td>R$ <?php echo e(number_format($f['conta_pagar'], 2, ',', '.')); ?></td>
					<?php 
					$resultado = $f['credito_venda']+$f['conta_receber']+$f['venda_caixa']+$f['venda']-$f['conta_pagar'];
					?>
					<td>
						<?php if($resultado > 0): ?>
						<h5 class="green-text"> R$ <?php echo e(number_format($resultado, 2, ',', '.')); ?></h5>
						<?php elseif($resultado == 0): ?>
						<h5 class="blue-text"> R$ <?php echo e(number_format($resultado, 2, ',', '.')); ?></h5>
						<?php else: ?>
						<h5 class="red-text"> R$ <?php echo e(number_format($resultado, 2, ',', '.')); ?></h5>
						<?php endif; ?>
					</td>

					<?php  
					$totalVenda += $f['venda']+$f['venda_caixa'];
					$totalContaReceber += $f['conta_receber'];
					$totalContaPagar += $f['conta_pagar'];
					$totalCredito += $f['credito_venda'];
					$totalResultado += $resultado; 
					?>
				</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr bgcolor="#FF0000">
					<td>SOMATÓRIO</td>
					<td>R$ <?php echo e(number_format($totalVenda, 2, ',', '.')); ?></td>
					<td>R$ <?php echo e(number_format($totalContaReceber, 2, ',', '.')); ?></td>
					<td>R$ <?php echo e(number_format($totalCredito, 2, ',', '.')); ?></td>
					<td>R$ <?php echo e(number_format($totalContaPagar, 2, ',', '.')); ?></td>
					<td>R$ <?php echo e(number_format($totalResultado, 2, ',', '.')); ?></td>
				</tr>
			</tbody>
		</table>


	</div>

</body>
</html><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/fluxoCaixa/relatorio.blade.php ENDPATH**/ ?>