<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relátorio de Estoque</h3>
		<h3 class="center-align">Categoria: <?php echo e($categoria); ?></h3>

	</div>


	<table class="pure-table">
		<thead>
			<tr>

				<th width="200">PRODUTO</th>
				<th width="80">ESTOQUE ATUAL</th>
				<th width="70">CUSTO</th>
				<th width="70">MARGEM LUCRO</th>
				<th width="80">VALOR DE VENDA</th>
				<th width="110">PROJEÇÃO TOTAL DE VENDAS</th>
				<th width="100">VALOR TOTAL DE ESTOQUE</th>
				<th width="70">DATA ULT. COMPRA</th>
			</tr>
		</thead>


		<tbody>
			<?php 
			$somaEstoque = 0;
			$somaValorEstoque = 0;
			$somaValorCusto = 0;
			?>
			<?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr class="<?php if($key%2 == 0): ?> pure-table-odd <?php endif; ?>">

				<td><?php echo e($p->nome); ?> <?php echo e($p->str_grade); ?></td>
				<?php if($p->unidade_venda == 'UNID' || $p->unidade_venda == 'UN'): ?>
				<td><?php echo e(number_format($p->quantidade)); ?> <?php echo e($p->unidade_venda); ?></td>
				<?php else: ?>
				<td><?php echo e(number_format($p->quantidade, 3, ',', '.')); ?> <?php echo e($p->unidade_venda); ?></td>
				<?php endif; ?>
				<td>R$ <?php echo e(number_format($p->valor_compra, 2, ',', '.')); ?></td>
				<td><?php echo e(number_format($p->percentual_lucro, 2)); ?>%</td>
				<td>R$ <?php echo e(number_format($p->valor_venda, 2, ',', '.')); ?></td>
				<td>R$ <?php echo e(number_format($p->valor_venda*$p->quantidade, 2, ',', '.')); ?></td>
				<td>R$ <?php echo e(number_format($p->valor_compra*$p->quantidade, 2, ',', '.')); ?></td>
				<td><?php echo e($p->data_ultima_compra); ?></td>
				<?php 
				$somaEstoque += $p->quantidade;
				$somaValorEstoque += $p->valor_venda*$p->quantidade;
				$somaValorCusto += $p->valor_compra*$p->quantidade;
				?>
			</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
	<h4>Quantidade estoque: <strong style="color: blue"><?php echo e(number_format($somaEstoque, 2, ',', '.')); ?></strong></h4>

	<h4>Soma valor de venda: <strong style="color: green">R$<?php echo e(number_format($somaValorEstoque, 2, ',', '.')); ?></strong></h4>
	<h4>Soma valor de custo: <strong style="color: red">R$<?php echo e(number_format($somaValorCusto, 2, ',', '.')); ?></strong></h4>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('relatorios.cabecalho', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/relatorios/relatorio_estoque.blade.php ENDPATH**/ ?>