<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relátorio de Comissão</h3>
		<?php if($data_inicial && $data_final): ?>
		<h4>Periodo: <?php echo e($data_inicial); ?> - <?php echo e($data_final); ?></h4>
		<?php endif; ?>

		<?php if($funcionario != 'null'): ?>
		<h4>Funcionario: <strong><?php echo e($funcionario); ?></strong></h4>
		<?php endif; ?>

		<?php if($produto != 'null'): ?>
		<h4>Produto: <strong><?php echo e($produto); ?></strong></h4>
		<?php endif; ?>
	</div>


	<table class="pure-table">
		<thead>
			<tr>
				<th width="150">DATA</th>
				<th width="150">VALOR DA COMISSÃO</th>
				<th width="150">VALOR DA VENDA</th>
				<?php if($funcionario == 'null'): ?>
				<th width="150">VENDEDOR</th>
				<?php endif; ?>
			</tr>
		</thead>
		<?php
		$somaComissao = 0;
		$somaVendas = 0;
		?>
		<tbody>
			<?php $__currentLoopData = $comissoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr class="<?php if($key%2 == 0): ?> pure-table-odd <?php endif; ?>">
				<td><center><?php echo e(\Carbon\Carbon::parse($c->created_at)->format('d/m/Y H:i:s')); ?></center></td>
				<td><center><?php echo e(number_format($c->valor, 2, ',', '.')); ?></center></td>
				<td><center><?php echo e(number_format($c->valor_total_venda, 2, ',', '.')); ?></center></td>
				<?php if($funcionario == 'null'): ?>
				<td><center><?php echo e($c->funcionario); ?></center></td>
				<?php endif; ?>
			</tr>

			<?php
			$somaComissao += $c->valor;
			$somaVendas += $c->valor_total_venda;
			?>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>

	<h4>Soma comissão: <strong style="color: green"><?php echo e(number_format($somaComissao, 2, ',', '.')); ?></strong></h4>
	<h4>Soma Vendas: <strong style="color: purple"><?php echo e(number_format($somaVendas, 2, ',', '.')); ?></strong></h4>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('relatorios.cabecalho', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/relatorios/relatorio_comissao.blade.php ENDPATH**/ ?>