<?php $__env->startSection('content'); ?>
<div class="card card-custom gutter-b">

	<div class="card-body <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">
		<div class="content d-flex flex-column flex-column-fluid" id="kt_content" >

			<div class="row" id="anime" style="display: none">
				<div class="col s8 offset-s2">
					<lottie-player src="/anime/success.json" background="transparent" speed="0.8" style="width: 100%; height: 300px;" autoplay >
					</lottie-player>
				</div>
			</div>

			<div class="col-lg-12" id="content">

				<div class="row" id="div-cliente">
					<div class="col-xl-12">

						<div class="card card-custom gutter-b">
							<div class="card-body">

								<h4 class="center-align">CLIENTE</h4>
								<div class="row">

									<div class="col-sm-6 col-lg-6 col-12">
										<h5>Razão Social: <strong id="razao_social" class="text-success"><?php echo e($cliente->razao_social); ?></strong></h5>
										<h5>Nome Fantasia: <strong id="nome_fantasia" class="text-success"><?php echo e($cliente->nome_fantasia); ?></strong></h5>
										<h5>Logradouro: <strong id="logradouro" class="text-success"><?php echo e($cliente->rua); ?></strong></h5>
										<h5>Numero: <strong id="numero" class="text-success"><?php echo e($cliente->numero); ?></strong></h5>
										
									</div>
									<div class="col-sm-6 col-lg-6 col-12">
										<h5>CPF/CNPJ: <strong id="cnpj" class="text-success"><?php echo e($cliente->cpf_cnpj); ?></strong></h5>
										<h5>RG/IE: <strong id="ie" class="text-success"><?php echo e($cliente->ie_rg); ?></strong></h5>
										<h5>Fone: <strong id="fone" class="text-success"><?php echo e($cliente->telefone); ?></strong></h5>
										<h5>Cidade: <strong id="cidade" class="text-success"><?php echo e($cliente->cidade->nome); ?> (<?php echo e($cliente->cidade->uf); ?>)</strong></h5>

									</div>
								</div>
							</div>
						</div>
					</div>

				</div>

				<form class="row" method="post" action="/boleto/gerarStore">
					<input type="hidden" value="<?php echo e($contaReceber->id); ?>" name="conta_id">

					<?php echo csrf_field(); ?>
					<div class="col-xl-12">

						<div class="card card-custom gutter-b">
							<div class="card-body">
								<h4 class="center-align">DADOS DO BOLETO</h4>

								<div class="row">
									<div class="col-lg-12">

										<span class="text-danger"><i class="la la-exclamation-circle text-danger"></i> Após gerar o boleto não será possível editar os dados da conta a receber</span>
										<hr>
									</div>
								</div>

								<div class="row">
									<div class="col-lg-4">
										<h5>Valor: <strong id="cnpj" class="text-info"><?php echo e(number_format($contaReceber->valor_integral, $casasDecimais, ',', '.')); ?></strong></h5>
									</div>

									<div class="col-lg-4">
										<h5>Vencimento: <strong class="text-info"><?php echo e(\Carbon\Carbon::parse($contaReceber->data_vencimento)->format('d/m/Y')); ?></strong></h5>
									</div>
								</div>
								<div class="row">

									<div class="form-group col-lg-4 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Banco</label>
										<div class="">
											<div class="input-group">
												<select id="banco" name="banco_id" class="custom-select">
													<option value="">Selecione</option>
													<?php $__currentLoopData = $contasBancarias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option <?php if($contaPadrao != null && $contaPadrao->id == $c->id): ?> selected <?php endif; ?> value="<?php echo e($c->id); ?>" <?php if(old('banco_id') == $c->id): ?> selected <?php endif; ?> ><?php echo e($c->banco); ?> | AG:<?php echo e($c->agencia); ?> - C:<?php echo e($c->conta); ?></option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>
												<?php if($errors->has('banco_id')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('banco_id')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<input type="hidden" value="<?php echo e(json_encode($contasBancarias)); ?>" id="contas_json">

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Nº do boleto</label>
										<div class="">
											<div class="input-group">
												<input name="numero" type="text" class="form-control <?php if($errors->has('numero')): ?> is-invalid <?php endif; ?>" value="<?php echo e(old('numero')); ?>"/>
												<?php if($errors->has('numero')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('numero')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Nº do documento</label>
										<div class="">
											<div class="input-group">
												<input name="numero_documento" value="<?php echo e(old('numero_documento')); ?>" type="text" class="form-control <?php if($errors->has('numero_documento')): ?> is-invalid <?php endif; ?>"/>
												<?php if($errors->has('numero_documento')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('numero_documento')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Carteira</label>
										<div class="">
											<div class="input-group">
												<input id="carteira" name="carteira" value="<?php if($contaPadrao != null): ?> <?php echo e($contaPadrao->carteira); ?> <?php else: ?> <?php echo e(old('carteira')); ?> <?php endif; ?>" type="text" class="form-control <?php if($errors->has('carteira')): ?> is-invalid <?php endif; ?>"/>
												<?php if($errors->has('carteira')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('carteira')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Convênio</label>
										<div class="">
											<div class="input-group">
												<input id="convenio" name="convenio" value="<?php if($contaPadrao != null): ?> <?php echo e($contaPadrao->convenio); ?> <?php else: ?> <?php echo e(old('convenio')); ?> <?php endif; ?>" type="text" class="form-control <?php if($errors->has('convenio')): ?> is-invalid <?php endif; ?>"/>
												<?php if($errors->has('convenio')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('convenio')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Juros</label>
										<div class="">
											<div class="input-group">
												<input id="juros" value="<?php if($contaPadrao != null): ?> <?php echo e($contaPadrao->juros); ?> <?php else: ?> <?php echo e(old('juros')); ?> <?php endif; ?>" name="juros" type="text" class="form-control money-p"/>
											</div>
										</div>
									</div>

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Multa</label>
										<div class="">
											<div class="input-group">
												<input id="multa" value="<?php if($contaPadrao != null): ?> <?php echo e($contaPadrao->multa); ?> <?php else: ?> <?php echo e(old('multa')); ?> <?php endif; ?>" name="multa" type="text" class="form-control money-p"/>
											</div>
										</div>
									</div>

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Juros após (dias)</label>
										<div class="">
											<div class="input-group">
												<input id="juros_apos" value="<?php if($contaPadrao != null): ?> <?php echo e($contaPadrao->juros_apos); ?> <?php else: ?> <?php echo e(old('juros_apos')); ?> <?php endif; ?>" name="juros_apos" type="text" class="form-control"/>
											</div>
										</div>
									</div>


									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6">
										<label class="col-form-label">Tipo</label>
										<div class="">
											<div class="input-group">
												<select name="tipo" class="custom-select">
													<option <?php if($contaPadrao != null): ?> <?php if($contaPadrao->tipo == 'Cnab400'): ?> selected <?php endif; ?> <?php endif; ?> value="Cnab400">Cnab400</option>
													<option <?php if($contaPadrao != null): ?> <?php if($contaPadrao->tipo == 'Cnab240'): ?> selected <?php endif; ?> <?php endif; ?> value="Cnab240">Cnab240</option>
												</select>
											</div>
										</div>
									</div>

									<div class="form-group validated col-sm-4 col-lg-4">
										<label class="col-form-label">Usar logo</label>

										<div class="switch switch-outline switch-success">
											<label class="">
												<input value="true" name="logo" class="red-text" type="checkbox">
												<span class="lever"></span>
											</label>
										</div>
									</div>

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6 div-aux" style="display: none">
										<label class="col-form-label">Posto</label>
										<div class="">
											<div class="input-group">
												<input value="<?php echo e(old('posto')); ?>" id="posto" name="posto" type="text" class="form-control <?php if($errors->has('posto')): ?> is-invalid <?php endif; ?>"/>
												<?php if($errors->has('posto')): ?>
												<span class="text-danger">
													<?php echo e($errors->first('posto')); ?>

												</span>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="form-group col-lg-2 col-md-4 col-sm-6 col-6 div-aux" style="display: none">
										<label class="col-form-label">Código do cliente</label>
										<div class="">
											<div class="input-group">
												<input id="codigo_cliente" name="codigo_cliente" type="text" class="form-control <?php if($errors->has('codigo_cliente')): ?> is-invalid <?php endif; ?>"/>
												<?php if($errors->has('codigo_cliente')): ?>
												<span class="text-danger">
													<?php echo e($errors->first('codigo_cliente')); ?>

												</span>
												<?php endif; ?>
											</div>
										</div>
									</div>


									<div class="form-group col-12">
										<label class="col-form-label">Instruções</label>
										<div class="">
											<div class="input-group">
												<input name="instrucoes" type="text" class="form-control"/>
											</div>
										</div>
									</div>



								</div>
							</div>
						</div>
						<div class="card-footer">
							<div class="row">
								<div class="col-lg-3 col-sm-6 col-md-4">
									<button style="width: 100%" type="submit" class="btn btn-success">
										<i class="la la-check"></i>
										<span class="">Salvar</span>
									</button>
								</div>
							</div>
						</div>
					</div>

				</form>
			</div>
		</div>
	</div>
</div>

<?php $__env->startSection('javascript'); ?>

<script type="text/javascript">
	var CONTAS = [];

	$(function () {
		CONTAS = JSON.parse($('#contas_json').val());
		verificaBanco();
	})

	$('#banco').change(() => {
		verificaBanco();

		getDados((res) => {
			if(res){
				console.log(res)
				$('#carteira').val(res.carteira)
				$('#convenio').val(res.convenio)
				$('#juros').val(res.juros)
				$('#juros_apos').val(res.juros_apos)
				$('#multa').val(res.multa)
			}
		})
	})

	function verificaBanco(){
		$('#posto').val('')
		$('#codigo_cliente').val('')
		$('.div-aux').css('display', 'none')
		let banco = $('#banco').val();
		CONTAS.map((c) => {
			if(banco == c.id){
				console.log(c.banco)
				if(c.banco == 'Sicredi' || c.banco == 'Caixa Econônica Federal' || c.banco == 'Santander'){
					$('.div-aux').css('display', 'block')
				}
			}
		})
	}

	function getDados(call){
		let banco = $('#banco').val();
		if(banco){
			$.get(path + 'contaBancaria/find/'+banco)
			.done((res) => {
				call(res)
			})
			.fail((err) => {
				call(err)
			})
		}else{
			call(false)
		}
	}
</script>

<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/boletos/create.blade.php ENDPATH**/ ?>